/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.file;

import com.google.common.base.Preconditions;
import org.eclipse.core.runtime.IPath;

public final class RelativePathUtils {
    private RelativePathUtils() {
    }

    public static IPath getRelativePath(IPath base, IPath target) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((boolean)base.isAbsolute());
        Preconditions.checkArgument((boolean)target.isAbsolute());
        return target.makeRelativeTo(base);
    }

    public static IPath getAbsolutePath(IPath base, IPath relativePath) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)relativePath);
        Preconditions.checkArgument((boolean)base.isAbsolute());
        Preconditions.checkArgument((!relativePath.isAbsolute() ? 1 : 0) != 0);
        IPath result = base;
        for (String segment : relativePath.segments()) {
            IPath newResult = result.append(segment);
            if (segment.equals("..") && newResult.segmentCount() >= result.segmentCount()) {
                throw new IllegalArgumentException(String.format("Relative path can't point beyond the root (base=%s, relativePath=%s).", base, relativePath));
            }
            result = newResult;
        }
        return result;
    }
}

