/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.wizards;

import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.wizards.BPMN2DiagramWizardPage1;
import org.eclipse.bpmn2.modeler.ui.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class BPMN2DiagramWizardPage2
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private Text targetNamespaceText;
    private ISelection selection;
    private IResource diagramContainer;

    public BPMN2DiagramWizardPage2(ISelection selection) {
        super("wizardPage2");
        this.setTitle(Messages.BPMN2DiagramWizardPage2_Title);
        this.setDescription(Messages.BPMN2DiagramWizardPage2_Description);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.BPMN2DiagramWizardPage2_Location_Label);
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.setEditable(false);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BPMN2DiagramWizardPage2.this.targetNamespaceText.setText("");
                BPMN2DiagramWizardPage2.this.dialogChanged(true);
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.BPMN2DiagramWizardPage2_Browse_Button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BPMN2DiagramWizardPage2.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.BPMN2DiagramWizardPage2_File_Name_Label);
        this.fileText = new Text(container, 2052);
        this.fileText.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BPMN2DiagramWizardPage2.this.dialogChanged(false);
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.BPMN2DiagramWizardPage2_TargetNamespace_Label);
        this.targetNamespaceText = new Text(container, 2052);
        this.targetNamespaceText.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.targetNamespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BPMN2DiagramWizardPage2.this.dialogChanged(false);
            }
        });
        this.updatePageDescription();
        this.updateFilename();
        this.dialogChanged(true);
        this.setControl((Control)container);
    }

    private ModelUtil.Bpmn2DiagramType getDiagramType() {
        BPMN2DiagramWizardPage1 page1 = (BPMN2DiagramWizardPage1)this.getWizard().getPage("wizardPage1");
        return page1.getDiagramType();
    }

    private void updatePageDescription() {
        BPMN2DiagramWizardPage1 page1 = (BPMN2DiagramWizardPage1)this.getWizard().getPage("wizardPage1");
        String descriptionType = Messages.BPMN2DiagramWizardPage2_Error_Unknown_Type;
        switch (page1.getDiagramType()) {
            case PROCESS: {
                descriptionType = Messages.BPMN2DiagramWizardPage2_Process_Diagram;
                break;
            }
            case COLLABORATION: {
                descriptionType = Messages.BPMN2DiagramWizardPage2_Collaboration_Diagram;
                break;
            }
            case CHOREOGRAPHY: {
                descriptionType = Messages.BPMN2DiagramWizardPage2_Choreography_Diagram;
                break;
            }
        }
        this.setDescription(String.valueOf(Messages.BPMN2DiagramWizardPage2_Filename_Prompt) + descriptionType);
    }

    private void updateFilename() {
        BPMN2DiagramWizardPage1 page1 = (BPMN2DiagramWizardPage1)this.getWizard().getPage("wizardPage1");
        String fileType = "unknown";
        String filename = String.valueOf(fileType) + ".bpmn";
        switch (page1.getDiagramType()) {
            case PROCESS: {
                fileType = "process";
                break;
            }
            case COLLABORATION: {
                fileType = "collaboration";
                break;
            }
            case CHOREOGRAPHY: {
                fileType = "choreography";
                break;
            }
            default: {
                return;
            }
        }
        IContainer container = this.getFileContainer();
        if (container != null) {
            IResource file;
            String text = container.getFullPath().toString();
            if (text != null && !text.equals(this.getContainerName())) {
                this.containerText.setText(text);
            }
            int i = 1;
            while ((file = container.findMember(filename = String.valueOf(fileType) + "_" + i + ".bpmn")) != null) {
                ++i;
            }
        }
        String oldFileText = this.fileText.getText();
        if (filename != null && !filename.equals(oldFileText)) {
            this.fileText.setText(filename);
        }
    }

    private IContainer getFileContainer() {
        IStructuredSelection ssel;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)this.selection).size() == 1) {
            Object res;
            Object obj = ssel.getFirstElement();
            if (obj instanceof IAdaptable && (res = ((IAdaptable)obj).getAdapter(IResource.class)) != null) {
                obj = res;
            }
            if (obj instanceof Path) {
                obj = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)((Path)obj));
            }
            if (obj instanceof IResource) {
                if (obj instanceof IContainer) {
                    return (IContainer)obj;
                }
                return ((IResource)obj).getParent();
            }
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updatePageDescription();
            this.updateFilename();
        }
        super.setVisible(visible);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.BPMN2DiagramWizardPage2_Select_Folder_Title);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.selection = new TreeSelection(new TreePath(result));
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged(boolean initialize) {
        boolean complete = false;
        if (this.validateContainer()) {
            this.diagramContainer = this.getFileContainer();
            if (initialize) {
                TargetRuntime rt = Bpmn2Preferences.getInstance((IProject)this.diagramContainer.getProject()).getRuntime();
                String targetNamespace = rt.getRuntimeExtension().getTargetNamespace(this.getDiagramType());
                if (targetNamespace == null) {
                    targetNamespace = "";
                }
                if (rt != TargetRuntime.getDefaultRuntime() && !targetNamespace.isEmpty()) {
                    if (!this.targetNamespaceText.getText().equals(targetNamespace)) {
                        this.targetNamespaceText.setText(targetNamespace);
                        this.updateFilename();
                    }
                } else {
                    String text = this.targetNamespaceText.getText();
                    if (text == null || text.isEmpty()) {
                        this.targetNamespaceText.setText(targetNamespace);
                        this.updateFilename();
                    }
                }
            }
            if (this.validateFileName() && this.validateTargetNamespace()) {
                this.updateStatus(null);
                complete = true;
            }
        }
        this.setPageComplete(complete);
    }

    private boolean validateContainer() {
        IContainer container = this.getFileContainer();
        if (container == null) {
            this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_No_Container);
            return false;
        }
        if ((container.getType() & 6) == 0) {
            this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_No_Folder);
            return false;
        }
        if (!container.isAccessible()) {
            this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_Container_Readonly);
            return false;
        }
        return true;
    }

    private boolean validateFileName() {
        if (!this.validateContainer()) {
            return false;
        }
        IContainer container = this.getFileContainer();
        String fileName = this.getFileName();
        if (fileName.length() == 0) {
            this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_No_Filename);
            return false;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_Filename_Invalid);
            return false;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1) {
            String ext = fileName.substring(dotLoc + 1);
            if (!ext.equalsIgnoreCase("bpmn") && !ext.equalsIgnoreCase("bpmn2")) {
                this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_Extension_Invalid);
                return false;
            }
        } else {
            this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_No_Extension);
            return false;
        }
        IResource file = container.findMember(fileName);
        if (file != null) {
            this.setErrorMessage(NLS.bind((String)Messages.BPMN2DiagramWizardPage2_Error_Duplicate_File, (Object)fileName));
            return false;
        }
        return true;
    }

    private boolean validateTargetNamespace() {
        String targetNamespace = this.targetNamespaceText.getText();
        if (targetNamespace == null || targetNamespace.isEmpty()) {
            this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_No_TargetNamespace);
            return false;
        }
        URI uri = URI.createURI((String)targetNamespace);
        if (!uri.hasAuthority() || uri.scheme() == null) {
            this.setErrorMessage(Messages.BPMN2DiagramWizardPage2_Error_Invalid_TargetNamespace);
            return false;
        }
        return true;
    }

    public boolean isPageComplete() {
        return this.validateContainer() && this.validateFileName() && this.validateTargetNamespace();
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public IResource getDiagramContainer() {
        return this.diagramContainer;
    }

    public String getTargetNamespace() {
        return this.targetNamespaceText.getText();
    }
}

