/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.draw2d.ArrowButton;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollBarLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class TrayScrollBar
extends ScrollBar {
    protected static final int BUTTON_HEIGHT = 13;

    public TrayScrollBar() {
        this.setLayoutManager((LayoutManager)new ScrollBarLayout(this.transposer){

            protected Rectangle layoutButtons(ScrollBar scrollBar) {
                Rectangle bounds = this.transposer.t(scrollBar.getClientArea());
                Dimension buttonSize = new Dimension(bounds.width, 13);
                TrayScrollBar.this.getButtonUp().setBounds(this.transposer.t(new Rectangle(bounds.getTopLeft(), buttonSize)));
                Rectangle r = new Rectangle(bounds.x, bounds.bottom() - buttonSize.height, buttonSize.width, buttonSize.height);
                TrayScrollBar.this.getButtonDown().setBounds(this.transposer.t(r));
                Rectangle trackBounds = bounds.getCropped(new Insets(buttonSize.height, 0, buttonSize.height, 0));
                RangeModel model = scrollBar.getRangeModel();
                TrayScrollBar.this.getButtonUp().setVisible(model.getValue() != model.getMinimum());
                TrayScrollBar.this.getButtonDown().setVisible(model.getValue() != model.getMaximum() - model.getExtent());
                return trackBounds;
            }
        });
        this.setPageUp(null);
        this.setPageDown(null);
        this.setThumb(null);
        this.setOpaque(false);
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        IFigure result = super.findFigureAt(x, y, search);
        if (result != this) {
            return result;
        }
        return null;
    }

    public boolean containsPoint(int x, int y) {
        IFigure up = this.getButtonUp();
        IFigure down = this.getButtonDown();
        return up.isVisible() && up.getBounds().contains(x, y) || down.isVisible() && down.getBounds().contains(x, y);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(wHint, hHint);
    }

    protected Clickable createDefaultDownButton() {
        return this.createButton();
    }

    protected Clickable createDefaultUpButton() {
        return this.createButton();
    }

    protected Clickable createButton() {
        final Color foreground = CommonUIPlugin.getDefault().getColorRegistry().get("dark_shadow");
        Color background = CommonUIPlugin.getDefault().getColorRegistry().get("trayBackground");
        ArrowButton result = new ArrowButton(){

            protected void paintBorder(Graphics graphics) {
                graphics.setForegroundColor(foreground);
                Rectangle r = this.getBounds().getCopy();
                r.shrink(0, 2);
                --r.width;
                graphics.drawRectangle(r);
            }
        };
        result.setBackgroundColor(background);
        ((Triangle)result.getChildren().get(0)).setBackgroundColor(foreground);
        return result;
    }
}

