/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.internal.function.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionArgument;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionFactory;
import org.eclipse.birt.core.script.functionservice.impl.Argument;
import org.eclipse.birt.core.script.functionservice.impl.Category;
import org.eclipse.birt.core.script.functionservice.impl.CategoryWrapper;
import org.eclipse.birt.core.script.functionservice.impl.IFunctionProvider;
import org.eclipse.birt.core.script.functionservice.impl.ScriptFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Bundle;

public class FunctionProviderImpl
implements IFunctionProvider {
    private static final String EXTENSION_POINT = "org.eclipse.birt.core.ScriptFunctionService";
    private static final String ELEMENT_CATEGORY = "Category";
    private static final String ELEMENT_FUNCTION = "Function";
    private static final String ELEMENT_ARGUMENT = "Argument";
    private static final String ELEMENT_JSLIB = "JSLib";
    private static final String ELEMENT_DATATYPE = "DataType";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESC = "desc";
    private static final String ATTRIBUTE_FACTORYCLASS = "factoryclass";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_ISOPTIONAL = "isOptional";
    private static final String ATTRIBUTE_ALLOWVARARGUMENT = "variableArguments";
    private static final String ATTRIBUTE_ISSTATIC = "isStatic";
    private static final String ATTRIBUTE_ISCONSTRUCTOR = "isConstructor";
    private static final String ATTRIBUTE_LOCATION = "location";
    private static final String ATTRIBUTE_ISVISIBLE = "isVisible";
    private static final String DEFAULT_CATEGORYNAME = null;
    private Map<String, Category> categories;
    private List<URL> jsLibs = new ArrayList<URL>();
    private List<URL> jarLibs = new ArrayList<URL>();

    @Override
    public IScriptFunctionCategory[] getCategories() throws BirtException {
        return this.getCategoryMap().values().toArray(new IScriptFunctionCategory[0]);
    }

    @Override
    public IScriptFunction[] getFunctions(String categoryName) throws BirtException {
        if (this.getCategoryMap().containsKey(categoryName)) {
            Category category = this.getCategoryMap().get(categoryName);
            return category.getFunctions();
        }
        return new IScriptFunction[0];
    }

    @Override
    public void registerScriptFunction(Context cx, Scriptable scope) throws BirtException {
        List<CategoryWrapper> wrapperedCategories = this.getWrapperedCategories();
        for (CategoryWrapper category : wrapperedCategories) {
            ScriptableObject.putProperty((Scriptable)scope, (String)category.getClassName(), (Object)((Object)category));
        }
        if (!this.jarLibs.isEmpty()) {
            ClassLoader classLoader = cx.getApplicationClassLoader();
            URLClassLoader scriptClassLoader = this.createScriptClassLoader(this.jarLibs, classLoader);
            this.setApplicationClassLoader(scriptClassLoader, cx);
        }
        for (URL url : this.jsLibs) {
            try {
                Script script = cx.compileReader((Reader)new BufferedReader(new InputStreamReader(url.openStream())), null, 0, null);
                script.exec(cx, scope);
            }
            catch (IOException iOException) {}
        }
    }

    public void setApplicationClassLoader(final ClassLoader appLoader, Context context) {
        if (appLoader == null) {
            return;
        }
        ClassLoader loader = appLoader;
        try {
            appLoader.loadClass("org.mozilla.javascript.Context");
        }
        catch (ClassNotFoundException classNotFoundException) {
            loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new RhinoClassLoaderDecoration(appLoader, FunctionProviderImpl.class.getClassLoader());
                }
            });
        }
        context.setApplicationClassLoader(loader);
    }

    private synchronized URLClassLoader createScriptClassLoader(List urls, ClassLoader parent) {
        final URL[] jarUrls = urls.toArray(new URL[0]);
        final ClassLoader parentClassLoader = parent;
        URLClassLoader scriptClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(jarUrls, parentClassLoader);
            }
        });
        return scriptClassLoader;
    }

    private synchronized Map<String, Category> getCategoryMap() {
        if (this.categories != null) {
            return this.categories;
        }
        this.categories = new HashMap<String, Category>();
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT);
        if (extPoint == null) {
            return this.categories;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return this.categories;
        }
        int e = 0;
        while (e < exts.length) {
            try {
                IConfigurationElement[] configElems = exts[e].getConfigurationElements();
                if (configElems != null) {
                    int i = 0;
                    while (i < configElems.length) {
                        boolean isVisible = FunctionProviderImpl.extractBoolean(configElems[i].getAttribute(ATTRIBUTE_ISVISIBLE), true);
                        if (configElems[i].getName().equals(ELEMENT_CATEGORY)) {
                            Category category = new Category(configElems[i].getAttribute(ATTRIBUTE_NAME), configElems[i].getAttribute(ATTRIBUTE_DESC), isVisible);
                            this.categories.put(category.getName(), category);
                            IScriptFunctionFactory factory = null;
                            if (configElems[i].getAttribute(ATTRIBUTE_FACTORYCLASS) != null) {
                                factory = (IScriptFunctionFactory)configElems[i].createExecutableExtension(ATTRIBUTE_FACTORYCLASS);
                            }
                            IConfigurationElement[] functions = configElems[i].getChildren(ELEMENT_FUNCTION);
                            int j = 0;
                            while (j < functions.length) {
                                IScriptFunction function = FunctionProviderImpl.getScriptFunction(category, factory, functions[j]);
                                if (function != null) {
                                    category.addFunction(function);
                                }
                                ++j;
                            }
                        } else if (configElems[i].getName().equals(ELEMENT_FUNCTION)) {
                            IScriptFunction function;
                            if (this.categories.get(DEFAULT_CATEGORYNAME) == null) {
                                this.categories.put(DEFAULT_CATEGORYNAME, new Category(DEFAULT_CATEGORYNAME, null, isVisible));
                            }
                            if ((function = FunctionProviderImpl.getScriptFunction(this.categories.get(DEFAULT_CATEGORYNAME), null, configElems[i])) != null) {
                                this.categories.get(DEFAULT_CATEGORYNAME).addFunction(function);
                            }
                        } else if (configElems[i].getName().equals(ELEMENT_JSLIB)) {
                            FunctionProviderImpl.populateResources(this.jsLibs, ".js", configElems[i]);
                            FunctionProviderImpl.populateResources(this.jarLibs, ".jar", configElems[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (BirtException ex) {
                ex.printStackTrace();
            }
            ++e;
        }
        return this.categories;
    }

    private static void populateResources(List<URL> libs, String suffix, IConfigurationElement confElement) {
        String source = confElement.getAttribute(ATTRIBUTE_LOCATION);
        IExtension extension = confElement.getDeclaringExtension();
        String namespace = extension.getNamespace();
        Bundle bundle = org.eclipse.core.runtime.Platform.getBundle((String)namespace);
        if (bundle != null) {
            URL url;
            Enumeration files = bundle.getEntryPaths(source);
            if (files != null) {
                while (files.hasMoreElements()) {
                    URL url2;
                    String filePath = (String)files.nextElement();
                    if (!filePath.toLowerCase().endsWith(suffix) || (url2 = bundle.getEntry(filePath)) == null) continue;
                    libs.add(url2);
                }
            } else if (source.toLowerCase().endsWith(suffix) && (url = bundle.getEntry(source)) != null) {
                libs.add(url);
            }
        }
        if (bundle == null || libs.isEmpty()) {
            File file = new File(source);
            if (file.exists() && file.isDirectory()) {
                libs.addAll(FunctionProviderImpl.findFileList(file, suffix));
            } else if (source.toLowerCase().endsWith(suffix)) {
                try {
                    libs.add(new URL(source));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }

    private static List<URL> findFileList(File file, String suffix) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(suffix)) {
                try {
                    fileList.add(f.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (f.isDirectory()) {
                fileList.addAll(FunctionProviderImpl.findFileList(f, suffix));
            }
            ++n2;
        }
        return fileList;
    }

    private static IScriptFunction getScriptFunction(Category category, IScriptFunctionFactory factory, IConfigurationElement function) {
        try {
            String name = function.getAttribute(ATTRIBUTE_NAME);
            String desc = function.getAttribute(ATTRIBUTE_DESC);
            String varArgs = function.getAttribute(ATTRIBUTE_ALLOWVARARGUMENT);
            boolean allowVarArgs = FunctionProviderImpl.extractBoolean(varArgs, false);
            boolean isConstructor = FunctionProviderImpl.extractBoolean(function.getAttribute(ATTRIBUTE_ISCONSTRUCTOR), false);
            boolean isStatic = FunctionProviderImpl.extractBoolean(function.getAttribute(ATTRIBUTE_ISSTATIC), true);
            boolean isVisible = FunctionProviderImpl.extractBoolean(function.getAttribute(ATTRIBUTE_ISVISIBLE), true);
            String dataType = null;
            ArrayList<IScriptFunctionArgument> arguments = new ArrayList<IScriptFunctionArgument>();
            if (FunctionProviderImpl.hasChildren(ELEMENT_DATATYPE, function)) {
                dataType = function.getChildren(ELEMENT_DATATYPE)[0].getAttribute(ATTRIBUTE_VALUE);
            }
            if (FunctionProviderImpl.hasChildren(ELEMENT_ARGUMENT, function)) {
                int i = 0;
                while (i < function.getChildren(ELEMENT_ARGUMENT).length) {
                    arguments.add(FunctionProviderImpl.getScriptFunctionArgument(function.getChildren(ELEMENT_ARGUMENT)[i]));
                    ++i;
                }
            }
            return new ScriptFunction(name, category, arguments.toArray(new IScriptFunctionArgument[0]), dataType, desc, factory == null ? null : factory.getFunctionExecutor(name), allowVarArgs, isStatic, isConstructor, isVisible);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean extractBoolean(String strValue, boolean ifNull) throws BirtException {
        boolean booleanValue = strValue == null ? ifNull : DataTypeUtil.toBoolean(strValue);
        return booleanValue;
    }

    private static IScriptFunctionArgument getScriptFunctionArgument(IConfigurationElement argument) throws BirtException {
        String name = argument.getAttribute(ATTRIBUTE_NAME);
        String desc = argument.getAttribute(ATTRIBUTE_DESC);
        String optional = argument.getAttribute(ATTRIBUTE_ISOPTIONAL);
        boolean isOptional = FunctionProviderImpl.extractBoolean(optional, false);
        String dataType = null;
        if (FunctionProviderImpl.hasChildren(ELEMENT_DATATYPE, argument)) {
            dataType = argument.getChildren(ELEMENT_DATATYPE)[0].getAttribute(ATTRIBUTE_VALUE);
        }
        return new Argument(name, dataType, desc, isOptional);
    }

    private static boolean hasChildren(String name, IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren(name);
        return children != null && children.length > 0;
    }

    private List<CategoryWrapper> getWrapperedCategories() throws BirtException {
        ArrayList<CategoryWrapper> result = new ArrayList<CategoryWrapper>();
        for (Category category : this.getCategoryMap().values()) {
            if (category.getName() == DEFAULT_CATEGORYNAME) continue;
            result.add(new CategoryWrapper(category));
        }
        return result;
    }

    private static class RhinoClassLoaderDecoration
    extends ClassLoader {
        private ClassLoader applicationClassLoader;
        private ClassLoader rhinoClassLoader;

        public RhinoClassLoaderDecoration(ClassLoader applicationClassLoader, ClassLoader rhinoClassLoader) {
            this.applicationClassLoader = applicationClassLoader;
            this.rhinoClassLoader = rhinoClassLoader;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.applicationClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.rhinoClassLoader.loadClass(name);
            }
        }
    }
}

