/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.swt.custom;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

class TextCanvas
extends Canvas
implements PaintListener,
FocusListener {
    private static final int DEFAULT_MARGIN = 3;
    private int leftMargin = 3;
    private int topMargin = 3;
    private int rightMargin = 3;
    private int bottomMargin = 3;
    private String text;
    private Font textFont;
    private boolean isFocusIn = false;

    public TextCanvas(Composite parent, int iStyle, String text) {
        super(parent, iStyle);
        this.text = text;
        this.addPaintListener(this);
        this.addFocusListener(this);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void paintControl(PaintEvent pe) {
        if (this.isEnabled() && this.isFocusControl()) {
            this.isFocusIn = true;
        }
        Color cForeground = null;
        Color cBackground = null;
        if (this.isEnabled()) {
            cForeground = this.getDisplay().getSystemColor(24);
            cBackground = this.getDisplay().getSystemColor(25);
        } else {
            cForeground = this.getDisplay().getSystemColor(16);
            cBackground = this.getDisplay().getSystemColor(22);
        }
        GC gc = pe.gc;
        if (this.isFocusIn) {
            gc.setBackground(this.getDisplay().getSystemColor(26));
            gc.setForeground(this.getDisplay().getSystemColor(27));
        } else {
            gc.setBackground(cBackground);
            gc.setForeground(cForeground);
        }
        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        if (this.textFont != null) {
            gc.setFont(this.textFont);
        }
        if (this.text != null) {
            gc.drawText(this.text, 2, 2);
        }
    }

    public void focusGained(FocusEvent e) {
        this.isFocusIn = true;
    }

    public void focusLost(FocusEvent e) {
        this.isFocusIn = false;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.text);
        e.x = wHint == -1 ? (e.x += this.leftMargin + this.rightMargin) : wHint;
        e.y = hHint == -1 ? (e.y += this.topMargin + this.bottomMargin) : hHint;
        return e;
    }

    private Point getTotalSize(String text) {
        Point size = new Point(0, 0);
        GC gc = new GC((Drawable)this);
        if (text != null && text.length() > 0) {
            Point e = gc.textExtent(text);
            size.x += e.x;
            size.y = Math.max(size.y, e.y);
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        gc.dispose();
        return size;
    }
}

