/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javax.servlet.jsp.tagext;

/**
 * Variable information for a tag in a Tag Library;
 * This class is instantiated from the Tag Library Descriptor file (TLD)
 * and is available only at translation time.
 *
 * This object should be immutable.
 *
 * This information is only available in JSP 1.2 format TLDs or above.
 */

public class TagVariableInfo {

    /**
     * Constructor for TagVariableInfo.
     *
     * @param nameGiven value of &lt;name-given&gt;
     * @param nameFromAttribute value of &lt;name-from-attribute&gt;
     * @param className value of &lt;variable-class&gt;
     * @param declare value of &lt;declare&gt;
     * @param scope value of &lt;scope&gt;
     */
    public TagVariableInfo(
	    String nameGiven,
	    String nameFromAttribute,
	    String className,
	    boolean declare,
	    int scope) {
	this.nameGiven         = nameGiven;
	this.nameFromAttribute = nameFromAttribute;
	this.className         = className;
	this.declare           = declare;
	this.scope             = scope;
    }

    /**
     * The body of the &lt;name-given&gt; element.
     *
     * @return The variable name as a constant
     */

    public String getNameGiven() {
	return nameGiven;
    }

    /**
     * The body of the &lt;name-from-attribute&gt; element.
     * This is the name of an attribute whose (translation-time)
     * value will give the name of the variable.  One of
     * &lt;name-given&gt; or &lt;name-from-attribute&gt; is required.
     *
     * @return The attribute whose value defines the variable name
     */

    public String getNameFromAttribute() {
	return nameFromAttribute;
    }

    /**
     * The body of the &lt;variable-class&gt; element.  
     *
     * @return The name of the class of the variable or
     *         'java.lang.String' if not defined in the TLD.
     */

    public String getClassName() {
	return className;
    }

    /**
     * The body of the &lt;declare&gt; element.
     *
     * @return Whether the variable is to be declared or not.
     *         If not defined in the TLD, 'true' will be returned.
     */

    public boolean getDeclare() {
	return declare;
    }

    /**
     * The body of the &lt;scope&gt; element.
     *
     * @return The scope to give the variable.  NESTED
     *         scope will be returned if not defined in 
     *         the TLD.
     */

    public int getScope() {
	return scope;
    }


    /*
     * private fields
     */
    private String   nameGiven;         // <name-given>
    private String   nameFromAttribute; // <name-from-attribute>
    private String   className;         // <class>
    private boolean  declare;           // <declare>
    private int      scope;             // <scope>
}
