/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

public final class ClosureCheckModule
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final DiagnosticType MULTIPLE_MODULES_IN_FILE = DiagnosticType.error("JSC_MULTIPLE_MODULES_IN_FILE", "There should only be a single goog.module() statement per file.");
    static final DiagnosticType MODULE_AND_PROVIDES = DiagnosticType.error("JSC_MODULE_AND_PROVIDES", "A file using goog.module() may not also use goog.provide() statements.");
    static final DiagnosticType GOOG_MODULE_REFERENCES_THIS = DiagnosticType.error("JSC_GOOG_MODULE_REFERENCES_THIS", "The body of a goog.module cannot reference 'this'.");
    static final DiagnosticType GOOG_MODULE_USES_THROW = DiagnosticType.error("JSC_GOOG_MODULE_USES_THROW", "The body of a goog.module cannot use 'throw'.");
    static final DiagnosticType REQUIRE_NOT_AT_TOP_LEVEL = DiagnosticType.error("JSC_REQUIRE_NOT_AT_TOP_LEVEL", "goog.require() must be called at file scope.");
    static final DiagnosticType ONE_REQUIRE_PER_DECLARATION = DiagnosticType.error("JSC_ONE_REQUIRE_PER_DECLARATION", "There may only be one goog.require() per var/let/const declaration.");
    private final AbstractCompiler compiler;
    private Node currentModule = null;

    public ClosureCheckModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            return NodeUtil.isModuleFile(n);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 37: {
                Node callee = n.getFirstChild();
                if (callee.matchesQualifiedName("goog.module")) {
                    if (this.currentModule == null) {
                        this.currentModule = n;
                        break;
                    }
                    t.report(n, MULTIPLE_MODULES_IN_FILE, new String[0]);
                    break;
                }
                if (callee.matchesQualifiedName("goog.provide")) {
                    t.report(n, MODULE_AND_PROVIDES, new String[0]);
                    break;
                }
                if (!callee.matchesQualifiedName("goog.require")) break;
                this.checkRequireCall(t, n, parent);
                break;
            }
            case 42: {
                if (!t.inGlobalHoistScope()) break;
                t.report(n, GOOG_MODULE_REFERENCES_THIS, new String[0]);
                break;
            }
            case 49: {
                if (!t.inGlobalHoistScope()) break;
                t.report(n, GOOG_MODULE_USES_THROW, new String[0]);
                break;
            }
            case 132: {
                this.currentModule = null;
            }
        }
    }

    private void checkRequireCall(NodeTraversal t, Node callNode, Node parent) {
        Preconditions.checkState((boolean)callNode.isCall());
        switch (parent.getType()) {
            case 130: {
                return;
            }
            case 33: {
                if (!parent.getParent().isName()) break;
                this.checkRequireCall(t, callNode, parent.getParent());
                return;
            }
            case 38: 
            case 157: {
                Node declaration = parent.getParent();
                if (declaration.getChildCount() != 1) {
                    t.report(declaration, ONE_REQUIRE_PER_DECLARATION, new String[0]);
                }
                return;
            }
        }
        t.report(callNode, REQUIRE_NOT_AT_TOP_LEVEL, new String[0]);
    }
}

