/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.AccountGroup;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.Project;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import com.google.gwtorm.client.StringKey;
import java.util.Comparator;

public final class RefRight {
    public static final String ALL = "refs/*";
    public static final String REGEX_PREFIX = "^";
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected short minValue;
    @Column(id=3)
    protected short maxValue;
    public static final Comparator<RefRight> REF_PATTERN_ORDER = new Comparator<RefRight>(){

        @Override
        public int compare(RefRight a, RefRight b) {
            int aLength = a.getRefPattern().length();
            int bLength = b.getRefPattern().length();
            if (bLength == aLength) {
                ApprovalCategory.Id aCat = a.getApprovalCategoryId();
                ApprovalCategory.Id bCat = b.getApprovalCategoryId();
                if (aCat.get().equals(bCat.get())) {
                    return a.getRefPattern().compareTo(b.getRefPattern());
                }
                return a.getApprovalCategoryId().get().compareTo(b.getApprovalCategoryId().get());
            }
            return bLength - aLength;
        }
    };

    protected RefRight() {
    }

    public RefRight(Key key) {
        this.key = key;
    }

    public Key getKey() {
        return this.key;
    }

    public String getRefPattern() {
        if (this.isExclusive()) {
            return this.key.refPattern.get().substring(1);
        }
        return this.key.refPattern.get();
    }

    public String getRefPatternForDisplay() {
        return this.key.refPattern.get();
    }

    public Project.NameKey getProjectNameKey() {
        return this.getKey().getProjectNameKey();
    }

    public boolean isExclusive() {
        return this.key.refPattern.get().startsWith("-");
    }

    public ApprovalCategory.Id getApprovalCategoryId() {
        return this.key.categoryId;
    }

    public AccountGroup.Id getAccountGroupId() {
        return this.key.groupId;
    }

    public short getMinValue() {
        return this.minValue;
    }

    public void setMinValue(short m) {
        this.minValue = m;
    }

    public short getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(short m) {
        this.maxValue = m;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{group :");
        s.append(this.getAccountGroupId().get());
        s.append(", proj :");
        s.append(this.getProjectNameKey().get());
        s.append(", cat :");
        s.append(this.getApprovalCategoryId().get());
        s.append(", pattern :");
        s.append(this.getRefPatternForDisplay());
        s.append(", min :");
        s.append(this.getMinValue());
        s.append(", max :");
        s.append(this.getMaxValue());
        s.append("}");
        return s.toString();
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RefRight) {
            RefRight a = this;
            RefRight b = (RefRight)o;
            return a.getKey().equals((Object)b.getKey()) && a.getMinValue() == b.getMinValue() && a.getMaxValue() == b.getMaxValue();
        }
        return false;
    }

    public static class Key
    extends CompoundKey<Project.NameKey> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Project.NameKey projectName;
        @Column(id=2)
        protected RefPattern refPattern;
        @Column(id=3)
        protected ApprovalCategory.Id categoryId;
        @Column(id=4)
        protected AccountGroup.Id groupId;

        protected Key() {
            this.projectName = new Project.NameKey();
            this.refPattern = new RefPattern();
            this.categoryId = new ApprovalCategory.Id();
            this.groupId = new AccountGroup.Id();
        }

        public Key(Project.NameKey projectName, RefPattern refPattern, ApprovalCategory.Id categoryId, AccountGroup.Id groupId) {
            this.projectName = projectName;
            this.refPattern = refPattern;
            this.categoryId = categoryId;
            this.groupId = groupId;
        }

        public Project.NameKey getParentKey() {
            return this.projectName;
        }

        public Project.NameKey getProjectNameKey() {
            return this.projectName;
        }

        public String getRefPattern() {
            return this.refPattern.get();
        }

        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.refPattern, this.categoryId, this.groupId};
        }
    }

    public static class RefPattern
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String pattern;

        protected RefPattern() {
        }

        public RefPattern(String pattern) {
            this.pattern = pattern;
        }

        public String get() {
            return this.pattern;
        }

        protected void set(String pattern) {
            this.pattern = pattern;
        }
    }
}

