/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;

public final class BuildOperationDescriptor {
    private final OperationIdentifier id;
    private final OperationIdentifier parentId;
    private final String displayName;
    private final String name;
    private final String progressDisplayName;
    private final Object details;
    private final BuildOperationCategory operationType;
    private final int totalProgress;

    private BuildOperationDescriptor(OperationIdentifier id, OperationIdentifier parentId, String name, String displayName, String progressDisplayName, Object details, BuildOperationCategory operationType, int totalProgress) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.displayName = displayName;
        this.progressDisplayName = progressDisplayName;
        this.details = details;
        this.operationType = operationType;
        this.totalProgress = totalProgress;
    }

    public OperationIdentifier getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getProgressDisplayName() {
        return this.progressDisplayName;
    }

    @Nullable
    public Object getDetails() {
        return this.details;
    }

    @Nullable
    public OperationIdentifier getParentId() {
        return this.parentId;
    }

    public BuildOperationCategory getOperationType() {
        return this.operationType;
    }

    public int getTotalProgress() {
        return this.totalProgress;
    }

    public static Builder displayName(String displayName) {
        return new Builder(displayName);
    }

    public static final class Builder {
        private final String displayName;
        private String name;
        private String progressDisplayName;
        private Object details;
        private BuildOperationRef parent;
        private BuildOperationCategory operationType = BuildOperationCategory.UNCATEGORIZED;
        private int totalProgress;

        private Builder(String displayName) {
            this.displayName = displayName;
            this.name = displayName;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder progressDisplayName(String progressDisplayName) {
            this.progressDisplayName = progressDisplayName;
            return this;
        }

        public Builder details(Object details) {
            this.details = details;
            return this;
        }

        public Builder operationType(BuildOperationCategory operationType) {
            this.operationType = operationType;
            return this;
        }

        public void totalProgress(int totalProgress) {
            this.totalProgress = totalProgress;
        }

        public Builder parent(BuildOperationRef parent) {
            this.parent = parent;
            return this;
        }

        public BuildOperationDescriptor build() {
            return this.build(null, null);
        }

        BuildOperationRef getParentState() {
            return this.parent;
        }

        public BuildOperationDescriptor build(@Nullable OperationIdentifier id, @Nullable OperationIdentifier defaultParentId) {
            return new BuildOperationDescriptor(id, this.parent == null ? defaultParentId : this.parent.getId(), this.name, this.displayName, this.progressDisplayName, this.details, this.operationType, this.totalProgress);
        }
    }
}

