/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleStructures;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.constraints.BasicEntityConstraint;
import org.eclipse.zest.layouts.constraints.EntityPriorityConstraint;
import org.eclipse.zest.layouts.constraints.LabelLayoutConstraint;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;

public class SimpleNode
implements LayoutEntity {
    private static Object NODE_NORMAL_COLOR;
    private static Object NODE_SELECTED_COLOR;
    private static Object NODE_ADJACENT_COLOR;
    private static Object BORDER_NORMAL_COLOR;
    private static Object BORDER_SELECTED_COLOR;
    private static Object BORDER_ADJACENT_COLOR;
    private static final int BORDER_NORMAL_STROKE = 1;
    private static final int BORDER_STROKE_SELECTED = 2;
    private Map attributes;
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    protected Object realObject;
    private boolean ignoreInLayout = false;
    private Object colour = null;
    private Object borderColor = null;
    private int borderWidth;
    private TreeSet listOfRels = null;
    private Object internalNode;

    public SimpleNode(Object realObject) {
        this(realObject, -1.0, -1.0, 110.0, 110.0);
    }

    public SimpleNode(Object realObject, double x, double y, double width, double height) {
        this.realObject = realObject;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.attributes = new HashMap();
        this.borderWidth = 1;
        this.listOfRels = new TreeSet(new UniqueCompare());
        this.colour = NODE_NORMAL_COLOR;
        this.borderColor = BORDER_NORMAL_COLOR;
    }

    public static void setNodeColors(Object nodeNormalColor, Object borderNormalColor, Object nodeSelectedColor, Object nodeAdjacentColor, Object borderSelectedColor, Object borderAdjacentColor) {
        NODE_NORMAL_COLOR = nodeNormalColor;
        BORDER_NORMAL_COLOR = borderNormalColor;
        NODE_SELECTED_COLOR = nodeSelectedColor;
        NODE_ADJACENT_COLOR = nodeAdjacentColor;
        BORDER_SELECTED_COLOR = borderSelectedColor;
        BORDER_ADJACENT_COLOR = borderAdjacentColor;
    }

    public void addRelationship(SimpleRelationship rel) {
        this.listOfRels.add(rel);
    }

    public SimpleRelationship[] getRelationships() {
        int size = this.listOfRels.size();
        return this.listOfRels.toArray(new SimpleRelationship[size]);
    }

    public List getRelatedEntities() {
        int size = this.listOfRels.size();
        SimpleRelationship[] a_listOfRels = this.listOfRels.toArray(new SimpleRelationship[size]);
        LinkedList<LayoutEntity> listOfRelatedEntities = new LinkedList<LayoutEntity>();
        int i = 0;
        while (i < a_listOfRels.length) {
            SimpleRelationship rel = a_listOfRels[i];
            if (rel.sourceEntity != this && rel.destinationEntity != this) {
                throw new RuntimeException("Problem, we have a relationship and we are not the source or the dest");
            }
            if (rel.sourceEntity != this) {
                listOfRelatedEntities.add(rel.sourceEntity);
            }
            if (rel.destinationEntity != this) {
                listOfRelatedEntities.add(rel.destinationEntity);
            }
            ++i;
        }
        return listOfRelatedEntities;
    }

    public void ignoreInLayout(boolean ignore) {
        this.ignoreInLayout = ignore;
    }

    public Object getRealObject() {
        return this.realObject;
    }

    public boolean hasPreferredLocation() {
        return this.ignoreInLayout;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setSizeInLayout(double width, double height) {
        if (!this.ignoreInLayout) {
            this.width = width;
            this.height = height;
        }
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocationInLayout(double x, double y) {
        if (!this.ignoreInLayout) {
            this.x = x;
            this.y = y;
        }
    }

    public void setAttributeInLayout(Object attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public Object getAttributeInLayout(Object attribute) {
        return this.attributes.get(attribute);
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)object;
            result = this.realObject.equals(node.getRealObject());
        }
        return result;
    }

    public int hashCode() {
        return this.realObject.hashCode();
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public String toString() {
        return this.realObject.toString();
    }

    public void setSelected() {
        this.colour = NODE_SELECTED_COLOR;
        this.borderColor = BORDER_SELECTED_COLOR;
        this.borderWidth = 2;
    }

    public void setUnSelected() {
        this.colour = NODE_NORMAL_COLOR;
        this.borderColor = BORDER_NORMAL_COLOR;
        this.borderWidth = 1;
    }

    public void setAdjacent() {
        this.colour = NODE_ADJACENT_COLOR;
        this.borderColor = BORDER_ADJACENT_COLOR;
        this.borderWidth = 2;
    }

    public Object getColor() {
        return this.colour;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Object getBorderColor() {
        return this.borderColor;
    }

    public Object getLayoutInformation() {
        return this.internalNode;
    }

    public void setLayoutInformation(Object internalEntity) {
        this.internalNode = internalEntity;
    }

    public void populateLayoutConstraint(LayoutConstraint constraint) {
        if (constraint instanceof LabelLayoutConstraint) {
            LabelLayoutConstraint labelConstraint = (LabelLayoutConstraint)constraint;
            labelConstraint.label = this.realObject.toString();
            labelConstraint.pointSize = 18;
        } else if (!(constraint instanceof BasicEntityConstraint) && constraint instanceof EntityPriorityConstraint) {
            EntityPriorityConstraint priorityConstraint = (EntityPriorityConstraint)constraint;
            priorityConstraint.priority = Math.random() * 10.0 + 1.0;
        }
    }

    public double getHeightInLayout() {
        return this.height;
    }

    public double getWidthInLayout() {
        return this.width;
    }

    public double getXInLayout() {
        return this.x;
    }

    public double getYInLayout() {
        return this.y;
    }

    public Object getGraphData() {
        return null;
    }

    public void setGraphData(Object o) {
    }

    class UniqueCompare
    implements Comparator {
        UniqueCompare() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

