/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IBatchLinkableResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.IXtextModelListenerExtension;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AttributedPosition;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingPresenter;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ITextAttributeProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.MergingHighlightedPositionAcceptor;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class HighlightingReconciler
implements ITextInputListener,
IXtextModelListener,
IXtextModelListenerExtension,
IHighlightedPositionAcceptor {
    @Inject(optional=true)
    private ISemanticHighlightingCalculator oldCalculator;
    @Inject(optional=true)
    private org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator newCalculator;
    @Inject
    private ITextAttributeProvider attributeProvider;
    @Inject
    private XtextDocumentUtil xtextDocumentUtil;
    private XtextEditor editor;
    private XtextSourceViewer sourceViewer;
    private HighlightingPresenter presenter;
    private final List<AttributedPosition> addedPositions = new ArrayList<AttributedPosition>();
    private List<AttributedPosition> removedPositions = new ArrayList<AttributedPosition>();
    private Map<PositionHandle, Integer> handleToListIndex = Maps.newHashMap();
    private int removedPositionCount;
    private final Object fReconcileLock = new Object();
    private boolean reconciling = false;

    private void startReconcilingPositions() {
        this.presenter.addAllPositions(this.removedPositions);
        this.removedPositionCount = this.removedPositions.size();
        int i = 0;
        while (i < this.removedPositionCount) {
            AttributedPosition position = this.removedPositions.get(i);
            this.handleToListIndex.put(new PositionHandle(position.getOffset(), position.getLength(), position.getHighlighting()), i);
            ++i;
        }
    }

    private void reconcilePositions(XtextResource resource, CancelIndicator cancelIndicator) {
        org.eclipse.xtext.ide.editor.syntaxcoloring.MergingHighlightedPositionAcceptor acceptor;
        if (this.oldCalculator != null && !DefaultSemanticHighlightingCalculator.class.equals(this.oldCalculator.getClass())) {
            acceptor = new MergingHighlightedPositionAcceptor(this.oldCalculator);
            acceptor.provideHighlightingFor(resource, this);
        } else if (this.newCalculator != null) {
            acceptor = new org.eclipse.xtext.ide.editor.syntaxcoloring.MergingHighlightedPositionAcceptor(this.newCalculator);
            acceptor.provideHighlightingFor(resource, (org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor)this, cancelIndicator);
        } else {
            throw new IllegalStateException("No semantic highlighting calculator bound.");
        }
        List<AttributedPosition> oldPositions = this.removedPositions;
        ArrayList<AttributedPosition> newPositions = new ArrayList<AttributedPosition>(this.removedPositionCount);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            AttributedPosition current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.removedPositions = newPositions;
    }

    @Override
    public void addPosition(int offset, int length, String ... ids) {
        AttributedPosition position;
        TextAttribute highlighting;
        TextAttribute textAttribute = highlighting = ids.length == 1 ? this.attributeProvider.getAttribute(ids[0]) : this.attributeProvider.getMergedAttributes(ids);
        if (highlighting == null) {
            return;
        }
        boolean isExisting = false;
        PositionHandle handle = new PositionHandle(offset, length, highlighting);
        Integer index = this.handleToListIndex.remove(handle);
        if (index != null) {
            position = this.removedPositions.get(index);
            if (position == null) {
                throw new IllegalStateException("Position may not be null if the handle is still present.");
            }
            isExisting = true;
            this.removedPositions.set(index, null);
            --this.removedPositionCount;
        }
        if (!isExisting && this.presenter != null) {
            position = this.presenter.createHighlightedPosition(offset, length, highlighting);
            this.addedPositions.add(position);
        }
    }

    private void updatePresentation(TextPresentation textPresentation, List<AttributedPosition> addedPositions, List<AttributedPosition> removedPositions, XtextResource resource) {
        final Runnable runnable = this.presenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        final XtextResourceSet resourceSet = (XtextResourceSet)resource.getResourceSet();
        final int modificationStamp = resourceSet.getModificationStamp();
        Display display = this.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (HighlightingReconciler.this.sourceViewer != null && modificationStamp == resourceSet.getModificationStamp()) {
                    runnable.run();
                }
            }
        });
    }

    private Display getDisplay() {
        XtextEditor editor = this.editor;
        if (editor == null) {
            if (this.sourceViewer != null) {
                return this.sourceViewer.getControl().getDisplay();
            }
            return null;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return null;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return null;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        return display;
    }

    private void stopReconcilingPositions() {
        this.removedPositions.clear();
        this.removedPositionCount = 0;
        this.handleToListIndex.clear();
        this.addedPositions.clear();
    }

    public void install(XtextEditor editor, XtextSourceViewer sourceViewer, HighlightingPresenter presenter) {
        this.presenter = presenter;
        this.editor = editor;
        this.sourceViewer = sourceViewer;
        if (this.oldCalculator != null || this.newCalculator != null) {
            if (editor == null) {
                sourceViewer.getXtextDocument().addModelListener(this);
            } else if (editor.getDocument() != null) {
                editor.getDocument().addModelListener(this);
            }
            sourceViewer.addTextInputListener(this);
        }
        this.refresh();
    }

    public void uninstall() {
        if (this.presenter != null) {
            this.presenter.setCanceled(true);
        }
        if (this.sourceViewer.getDocument() != null && (this.oldCalculator != null || this.newCalculator != null)) {
            IXtextDocument document = this.xtextDocumentUtil.getXtextDocument((ITextViewer)this.sourceViewer);
            if (document != null) {
                document.removeModelListener(this);
            }
            this.sourceViewer.removeTextInputListener(this);
        }
        this.editor = null;
        this.sourceViewer = null;
        this.presenter = null;
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        IXtextDocument xtextDocument;
        if (oldInput != null && (xtextDocument = this.xtextDocumentUtil.getXtextDocument(oldInput)) != null) {
            xtextDocument.removeModelListener(this);
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.refresh();
            IXtextDocument xtextDocument = this.xtextDocumentUtil.getXtextDocument(newInput);
            if (xtextDocument != null) {
                xtextDocument.addModelListener(this);
            }
        }
    }

    public void refresh() {
        if (this.oldCalculator != null || this.newCalculator != null) {
            new Job("calculating highlighting"){

                protected IStatus run(IProgressMonitor monitor) {
                    IXtextDocument document;
                    XtextSourceViewer mySourceViewer = HighlightingReconciler.this.sourceViewer;
                    if (mySourceViewer != null && (document = mySourceViewer.getXtextDocument()) != null) {
                        document.tryReadOnly((IUnitOfWork)new CancelableUnitOfWork<Void, XtextResource>(){

                            public Void exec(XtextResource state, CancelIndicator cancelIndicator) throws Exception {
                                HighlightingReconciler.this.beforeRefresh(state, cancelIndicator);
                                HighlightingReconciler.this.modelChanged(state, cancelIndicator);
                                return null;
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            Display display = this.getDisplay();
            display.asyncExec(this.presenter.createSimpleUpdateRunnable());
        }
    }

    protected void beforeRefresh(XtextResource resource, CancelIndicator cancelIndicator) {
        if (resource instanceof DerivedStateAwareResource) {
            resource.getContents();
        }
        if (resource instanceof IBatchLinkableResource) {
            ((IBatchLinkableResource)resource).linkBatched(cancelIndicator);
        }
    }

    @Override
    public void modelChanged(XtextResource resource) {
        this.modelChanged(resource, CancelIndicator.NullImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelChanged(XtextResource resource, CancelIndicator cancelIndicator) {
        TextPresentation textPresentation;
        HighlightingPresenter highlightingPresenter;
        block44: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            Object object;
                            if (resource == null) {
                                return;
                            }
                            Object object2 = this.fReconcileLock;
                            synchronized (object2) {
                                if (this.reconciling) {
                                    return;
                                }
                                this.reconciling = true;
                            }
                            highlightingPresenter = this.presenter;
                            try {
                                if (highlightingPresenter != null) break block40;
                                if (highlightingPresenter != null) {
                                    highlightingPresenter.setCanceled(false);
                                }
                                this.stopReconcilingPositions();
                                object = this.fReconcileLock;
                            }
                            catch (Throwable throwable) {
                                if (highlightingPresenter != null) {
                                    highlightingPresenter.setCanceled(false);
                                }
                                this.stopReconcilingPositions();
                                Object object3 = this.fReconcileLock;
                                synchronized (object3) {
                                    this.reconciling = false;
                                }
                                throw throwable;
                            }
                            synchronized (object) {
                                this.reconciling = false;
                            }
                            return;
                        }
                        highlightingPresenter.setCanceled(cancelIndicator.isCanceled());
                        if (!highlightingPresenter.isCanceled()) break block41;
                        if (highlightingPresenter != null) {
                            highlightingPresenter.setCanceled(false);
                        }
                        this.stopReconcilingPositions();
                        Object object = this.fReconcileLock;
                        synchronized (object) {
                            this.reconciling = false;
                        }
                        return;
                    }
                    this.checkCanceled(cancelIndicator);
                    this.startReconcilingPositions();
                    if (!highlightingPresenter.isCanceled()) break block42;
                    if (highlightingPresenter != null) {
                        highlightingPresenter.setCanceled(false);
                    }
                    this.stopReconcilingPositions();
                    Object object = this.fReconcileLock;
                    synchronized (object) {
                        this.reconciling = false;
                    }
                    return;
                }
                this.checkCanceled(cancelIndicator);
                this.reconcilePositions(resource, cancelIndicator);
                if (!highlightingPresenter.isCanceled()) break block43;
                if (highlightingPresenter != null) {
                    highlightingPresenter.setCanceled(false);
                }
                this.stopReconcilingPositions();
                Object object = this.fReconcileLock;
                synchronized (object) {
                    this.reconciling = false;
                }
                return;
            }
            this.checkCanceled(cancelIndicator);
            textPresentation = highlightingPresenter.createPresentation(this.addedPositions, this.removedPositions);
            if (!highlightingPresenter.isCanceled()) break block44;
            if (highlightingPresenter != null) {
                highlightingPresenter.setCanceled(false);
            }
            this.stopReconcilingPositions();
            Object object = this.fReconcileLock;
            synchronized (object) {
                this.reconciling = false;
            }
            return;
        }
        this.checkCanceled(cancelIndicator);
        this.updatePresentation(textPresentation, this.addedPositions, this.removedPositions, resource);
        if (highlightingPresenter != null) {
            highlightingPresenter.setCanceled(false);
        }
        this.stopReconcilingPositions();
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.reconciling = false;
        }
    }

    protected void checkCanceled(CancelIndicator cancelIndicator) {
        if (cancelIndicator.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    @Deprecated
    public void setCalculator(ISemanticHighlightingCalculator calculator) {
        this.oldCalculator = calculator;
    }

    @Deprecated
    public ISemanticHighlightingCalculator getCalculator() {
        return this.oldCalculator;
    }

    private static class PositionHandle {
        private final int offset;
        private final int length;
        private final TextAttribute textAttribute;

        private PositionHandle(int offset, int length, TextAttribute textAttribute) {
            this.offset = offset;
            this.length = length;
            this.textAttribute = textAttribute;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.offset;
            result = 31 * result + (this.textAttribute == null ? 0 : this.textAttribute.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            PositionHandle other = (PositionHandle)obj;
            return this.offset == other.offset && this.length == other.length && this.textAttribute == other.textAttribute;
        }
    }
}

