/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.model.edit.BatchModification;
import org.eclipse.xtext.ui.editor.model.edit.ITextualMultiModification;
import org.eclipse.xtext.ui.editor.quickfix.AbstractIssueResolutionProviderAdapter;
import org.eclipse.xtext.ui.editor.quickfix.ILanguageResourceHelper;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.TextualMultiModificationWorkbenchMarkerResolutionAdapter;
import org.eclipse.xtext.ui.editor.quickfix.WorkbenchMarkerResolutionAdapter;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.validation.Issue;

public class MarkerResolutionGenerator
extends AbstractIssueResolutionProviderAdapter
implements IMarkerResolutionGenerator2 {
    @Inject
    private XtextEditorInfo editorInfo;
    private String editorId = null;
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private ILanguageResourceHelper languageResourceHelper;
    @Inject
    private IWorkbench workbench;
    @Inject
    private WorkbenchMarkerResolutionAdapter.Factory adapterFactory;
    @Inject
    private TextualMultiModificationWorkbenchMarkerResolutionAdapter.Factory textualMultiModificationAdapterFactory;
    @Inject
    private XtextDocumentUtil xtextDocumentUtil;

    public IssueUtil getIssueUtil() {
        return this.issueUtil;
    }

    public void setIssueUtil(IssueUtil issueUtil) {
        this.issueUtil = issueUtil;
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public String getEditorId() {
        if (this.editorId == null) {
            this.editorId = this.editorInfo.getEditorId();
        }
        return this.editorId;
    }

    public boolean hasResolutions(IMarker marker) {
        return this.getResolutionProvider().hasResolutionFor(this.getIssueUtil().getCode(marker));
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        IAnnotationModel annotationModel;
        IMarkerResolution[] emptyResult = new IMarkerResolution[]{};
        try {
            if (!marker.isSubtypeOf("org.eclipse.xtext.ui.check")) {
                return emptyResult;
            }
        }
        catch (CoreException e) {
            return emptyResult;
        }
        if (!this.languageResourceHelper.isLanguageResource(marker.getResource())) {
            return emptyResult;
        }
        XtextEditor editor = this.findEditor(marker.getResource());
        if (editor != null && (annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput())) != null && !this.isMarkerStillValid(marker, annotationModel)) {
            return emptyResult;
        }
        Issue issue = this.getIssueUtil().createIssue(marker);
        if (issue == null) {
            return emptyResult;
        }
        List<IssueResolution> resolutions = this.getResolutionProvider().getResolutions(issue);
        ArrayList result = Lists.newArrayList();
        ArrayList remaining = Lists.newArrayList();
        for (IssueResolution resolution : resolutions) {
            if (resolution.getModification() instanceof BatchModification.IBatchableModification) {
                result.add(this.adapterFactory.create(marker, resolution));
                continue;
            }
            if (resolution.getModification() instanceof ITextualMultiModification) {
                result.add(this.textualMultiModificationAdapterFactory.create(marker, resolution));
                continue;
            }
            remaining.add(resolution);
        }
        result.addAll(Lists.newArrayList((Object[])this.getAdaptedResolutions(remaining)));
        return result.toArray(new IMarkerResolution[result.size()]);
    }

    public boolean isMarkerStillValid(final IMarker marker, IAnnotationModel annotationModel) {
        Iterator iterator = annotationModel.getAnnotationIterator();
        return Iterators.any((Iterator)iterator, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation annotation) {
                if (annotation.isMarkedDeleted()) {
                    return false;
                }
                return this.referringToSameIssue(annotation, marker);
            }

            private boolean referringToSameIssue(Annotation annotation, IMarker marker2) {
                return MarkerResolutionGenerator.this.getIssueUtil().refersToSameIssue(marker2, annotation);
            }
        });
    }

    @Deprecated
    public IXtextDocument getXtextDocument(IResource resource) {
        IXtextDocument result = this.xtextDocumentUtil.getXtextDocument(resource);
        if (result == null) {
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            try {
                IFile file = ResourceUtil.getFile((Object)resource);
                FileEditorInput input = new FileEditorInput(file);
                IEditorPart newEditor = page.openEditor((IEditorInput)input, this.getEditorId());
                return this.xtextDocumentUtil.getXtextDocument(newEditor);
            }
            catch (PartInitException e) {
                return null;
            }
        }
        return result;
    }

    @Deprecated
    public XtextEditor getEditor(IResource resource) {
        XtextEditor result = this.findEditor(resource);
        if (result == null) {
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            try {
                IFile file = ResourceUtil.getFile((Object)resource);
                FileEditorInput input = new FileEditorInput(file);
                IEditorPart editor = page.openEditor((IEditorInput)input, this.getEditorId());
                if (editor instanceof XtextEditor) {
                    result = (XtextEditor)editor;
                } else if (editor != null) {
                    result = (XtextEditor)Adapters.adapt((Object)editor, XtextEditor.class);
                }
            }
            catch (PartInitException e) {
                return null;
            }
        }
        return result;
    }

    public XtextEditor findEditor(IResource resource) {
        if (resource instanceof IFile) {
            IWorkbenchPage activePage = this.workbench.getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = activePage.findEditor((IEditorInput)new FileEditorInput((IFile)resource));
            if (editor instanceof XtextEditor) {
                return (XtextEditor)editor;
            }
            if (editor != null) {
                return (XtextEditor)Adapters.adapt((Object)editor, XtextEditor.class);
            }
        }
        return null;
    }

    protected IMarkerResolution[] getAdaptedResolutions(List<IssueResolution> resolutions) {
        IMarkerResolution[] result = new IMarkerResolution[resolutions.size()];
        int i = 0;
        while (i < resolutions.size()) {
            result[i] = new ResolutionAdapter(resolutions.get(i));
            ++i;
        }
        return result;
    }

    public class ResolutionAdapter
    implements IMarkerResolution2 {
        private final IssueResolution resolution;

        public ResolutionAdapter(IssueResolution resolution) {
            this.resolution = resolution;
        }

        public String getLabel() {
            return this.resolution.getLabel();
        }

        public void run(IMarker marker) {
            this.resolution.apply();
        }

        public String getDescription() {
            return this.resolution.getDescription();
        }

        public Image getImage() {
            return MarkerResolutionGenerator.this.getImage(this.resolution);
        }
    }
}

