/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.doubleClicking;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.xtext.ui.editor.doubleClicking.AbstractWordAwareDoubleClickStrategy;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSourceAccess;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;

public class LexerTokenAndCharacterPairAwareStrategy
extends AbstractWordAwareDoubleClickStrategy {
    @Inject
    private ICharacterPairMatcher characterPairMatcher;
    @Inject
    private DocumentTokenSourceAccess tokenSourceAccess;

    @Override
    protected IRegion findWord(IDocument document, int offset) {
        Iterable<ILexerTokenRegion> tokenIterable = this.tokenSourceAccess.getTokens(document, true);
        if (tokenIterable == null) {
            return super.findWord(document, offset);
        }
        Iterator<ILexerTokenRegion> tokenIterator = tokenIterable.iterator();
        ILexerTokenRegion leadingToken = null;
        ILexerTokenRegion trailingToken = null;
        while (tokenIterator.hasNext()) {
            ILexerTokenRegion token = tokenIterator.next();
            if (token.getOffset() <= offset && token.getOffset() + token.getLength() >= offset) {
                if (leadingToken != null) {
                    trailingToken = token;
                } else {
                    leadingToken = token;
                }
            }
            if (token.getOffset() > offset) break;
        }
        if (leadingToken != null) {
            try {
                if (!(leadingToken.getLength() <= 1 || trailingToken != null && Character.isLetter(document.getChar(trailingToken.getOffset())))) {
                    return new Region(leadingToken.getOffset(), leadingToken.getLength());
                }
                if (trailingToken != null) {
                    return new Region(trailingToken.getOffset(), trailingToken.getLength());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return super.findWord(document, offset);
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        IRegion match = this.characterPairMatcher.match(document, offset);
        if (match != null && match.getLength() >= 2) {
            return new Region(match.getOffset() + 1, match.getLength() - 2);
        }
        return this.findWord(document, offset);
    }

    protected ICharacterPairMatcher getCharacterPairMatcher() {
        return this.characterPairMatcher;
    }
}

