/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Singleton
public class BuildExecutors {
    private final ListeningExecutorService sharedService;

    public BuildExecutors() {
        int nProcessors = Runtime.getRuntime().availableProcessors();
        int nThreads = Math.max(2, Math.min(4, nProcessors));
        this.sharedService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(nThreads, new ThreadFactoryBuilder().setNameFormat("ParallelGenerator-%d").build()));
    }

    public ListeningExecutorService getExecutor() {
        return this.sharedService;
    }
}

