/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal.preferences;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.xtend.shared.ui.core.internal.preferences.AbstractPreferencePage;
import org.eclipse.xtend.shared.ui.core.internal.preferences.PatternEditComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderPreferencePage
extends AbstractPreferencePage {
    private Combo incrementalAnalysisCombo;
    private PatternEditComposite exclusionPathsComposite;

    public BuilderPreferencePage() {
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor("org.eclipse.xtend.shared.ui", "icons/build_exec.gif"));
        this.setTitle("Builder");
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group grpSyntaxAnalysis = new Group(container, 0);
        grpSyntaxAnalysis.setLayout((Layout)new GridLayout(1, false));
        GridData gd_grpSyntaxAnalysis = new GridData(16384, 128, false, false, 1, 1);
        gd_grpSyntaxAnalysis.heightHint = 286;
        gd_grpSyntaxAnalysis.minimumWidth = 300;
        grpSyntaxAnalysis.setLayoutData((Object)gd_grpSyntaxAnalysis);
        grpSyntaxAnalysis.setText("Syntax Analysis");
        Label lblIncrementalAnalysisStrategy = new Label((Composite)grpSyntaxAnalysis, 0);
        lblIncrementalAnalysisStrategy.setText("Incremental Analysis Strategy");
        this.incrementalAnalysisCombo = new Combo((Composite)grpSyntaxAnalysis, 0);
        this.incrementalAnalysisCombo.setItems(new String[]{"On save, analyze current and dependent projects", "On save, analyze whole project", "On save, analyze file only", "On save, analyze file and reverse referenced only"});
        this.incrementalAnalysisCombo.select(0);
        Label lblExcludeFromAnalysis = new Label((Composite)grpSyntaxAnalysis, 0);
        lblExcludeFromAnalysis.setToolTipText("Enter path expressions here for resources that should be excluded from syntax analysis. Wildcard expressions are allowed, e.g. \"*/templates/*.ext\"");
        lblExcludeFromAnalysis.setText("Exclusion Patterns");
        this.exclusionPathsComposite = new PatternEditComposite((Composite)grpSyntaxAnalysis, 0);
        GridData gd_composite_2 = new GridData(16384, 128, true, true, 1, 1);
        gd_composite_2.widthHint = 359;
        this.exclusionPathsComposite.setLayoutData(gd_composite_2);
        this.applyData(this.getData());
        return container;
    }

    @Override
    public boolean performOk() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setValue("incrementalAnalyzerStrategy", this.incrementalAnalysisCombo.getSelectionIndex());
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String exclusionPaths = joiner.join((Object[])this.exclusionPathsComposite.getList().getItems());
        preferenceStore.setValue("builder.exclusions", exclusionPaths);
        return super.performOk();
    }

    protected Map<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        data.put("incrementalAnalyzerStrategy", preferenceStore.getInt("incrementalAnalyzerStrategy"));
        data.put("builder.exclusions", preferenceStore.getString("builder.exclusions"));
        return data;
    }

    public void applyData(Object data) {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.incrementalAnalysisCombo.select(preferenceStore.getInt("incrementalAnalyzerStrategy"));
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
        Iterable exclusionPaths = splitter.split((CharSequence)preferenceStore.getString("builder.exclusions"));
        this.exclusionPathsComposite.getList().setItems((String[])Iterables.toArray((Iterable)exclusionPaths, String.class));
    }

    protected String getPreferencePageID() {
        return "org.eclipse.xtend.shared.ui.properties.BuilderPreferencePage";
    }

    protected String getPropertyPageID() {
        return "org.eclipse.xtend.shared.ui.properties.BuilderPreferencePage";
    }

    @Override
    protected String[] getKeys() {
        return new String[]{"incrementalAnalyzerStrategy", "builder.exclusions"};
    }
}

