/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.xtend.shared.ui.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandProblemHover
implements IAnnotationHover,
ITextHover {
    private final ISourceViewer sourceViewer;
    private StringBuffer buffer;

    public XtendXpandProblemHover(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return this.getHoverInfoInternal(lineNumber, -1);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        int lineNumber;
        try {
            lineNumber = this.sourceViewer.getDocument().getLineOfOffset(hoverRegion.getOffset());
        }
        catch (BadLocationException e) {
            return null;
        }
        return this.getHoverInfoInternal(lineNumber, hoverRegion.getOffset());
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }

    private String getHoverInfoInternal(int lineNumber, int offset) {
        IAnnotationModel model = this.sourceViewer.getAnnotationModel();
        if (model == null) {
            return "";
        }
        ArrayList<String> messages = new ArrayList<String>();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            MarkerAnnotation mAnno = (MarkerAnnotation)annotation;
            int start = model.getPosition((Annotation)mAnno).getOffset();
            int end = start + model.getPosition((Annotation)mAnno).getLength();
            if (offset > 0 && (start > offset || offset > end)) continue;
            try {
                if (lineNumber != this.sourceViewer.getDocument().getLineOfOffset(start)) {
                }
            }
            catch (Exception x) {}
            continue;
            if (mAnno.getText() == null) continue;
            messages.add(mAnno.getText().trim());
        }
        return this.formatInfo(messages);
    }

    private String formatInfo(List<String> messages) {
        this.buffer = new StringBuffer();
        if (messages.size() > 1) {
            this.buffer.append(Messages.XtendXpandProblemHover_MultipleMarkers);
            Iterator<String> e = messages.iterator();
            while (e.hasNext()) {
                this.splitInfo("- " + e.next() + "\n");
            }
        } else if (messages.size() == 1) {
            this.splitInfo(messages.get(0));
        }
        return this.buffer.toString();
    }

    private String splitInfo(String message) {
        int pos;
        String prefix = "";
        do {
            if ((pos = message.indexOf(" ", 60)) > -1) {
                this.buffer.append(String.valueOf(prefix) + message.substring(0, pos) + "\n");
                message = message.substring(pos);
                prefix = "  ";
                continue;
            }
            this.buffer.append(String.valueOf(prefix) + message);
        } while (pos > -1);
        return this.buffer.toString();
    }
}

