/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP2012
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2012(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        WSDLValidatorImpl.BindingMatch[] bindingMatch = this.validator.getBindingMatches(binding, "document", "literal");
        if (bindingMatch.length == 0) {
            this.result = "notApplicable";
        } else {
            try {
                if (!this.validator.checkPartAttributes(bindingMatch, "useInput", "useElement") || !this.validator.checkPartAttributes(bindingMatch, "useOutput", "useElement")) {
                    throw new AssertionFailException("diagnostic: internal processing error!");
                }
            }
            catch (AssertionFailException e) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext, binding);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

