/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.css.core.internal.document.CSSAttrImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelParser;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.formatter.AttrChangeContext;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

class CSSModelUpdater {
    private CSSModelImpl fModel = null;
    private CSSModelParser fParser = null;

    CSSModelUpdater() {
    }

    CSSModelUpdater(CSSModelImpl model) {
        this.fModel = model;
    }

    private void attrInserted(CSSNodeImpl parentNode, CSSAttrImpl attr) {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)parentNode);
        if (formatter == null) {
            CSSUtil.debugOut("Cannot get format adapter : " + parentNode.getClass().toString());
            return;
        }
        short updateMode = 2;
        this.fParser.setupUpdateContext(updateMode, parentNode, attr);
        AttrChangeContext region = new AttrChangeContext();
        String text = new String(formatter.formatAttrChanged(parentNode, attr, true, region));
        this.insertText(region.start, region.end - region.start, text);
        this.fParser.cleanupUpdateContext();
    }

    private void attrRemoved(CSSNodeImpl parentNode, CSSAttrImpl attr) {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)parentNode);
        if (formatter == null) {
            CSSUtil.debugOut("Cannot get format adapter : " + parentNode.getClass().toString());
            return;
        }
        short updateMode = 4;
        this.fParser.setupUpdateContext(updateMode, parentNode, attr);
        AttrChangeContext region = new AttrChangeContext();
        String text = new String(formatter.formatAttrChanged(parentNode, attr, false, region));
        this.insertText(region.start, region.end - region.start, text);
        this.fParser.cleanupUpdateContext();
    }

    void attrReplaced(CSSNodeImpl parentNode, CSSNodeImpl newAttr, CSSNodeImpl oldAttr) {
        if (parentNode == null) {
            return;
        }
        if (oldAttr != null) {
            this.attrRemoved(parentNode, (CSSAttrImpl)oldAttr);
        }
        if (newAttr != null) {
            this.attrInserted(parentNode, (CSSAttrImpl)newAttr);
        }
    }

    private void childInserted(CSSNodeImpl parentNode, CSSNodeImpl node) {
        short updateMode = 0;
        if (node instanceof CSSStructuredDocumentRegionContainer) {
            updateMode = 1;
        } else if (node instanceof CSSRegionContainer) {
            updateMode = 2;
        } else {
            CSSUtil.debugOut("What's this node? : " + node.getClass().toString());
            return;
        }
        this.fParser.setupUpdateContext(updateMode, parentNode, node);
        this.defaultInserted(parentNode, node);
        this.fParser.cleanupUpdateContext();
    }

    private void childRemoved(CSSNodeImpl parentNode, CSSNodeImpl node) {
        short updateMode = 0;
        if (node instanceof CSSStructuredDocumentRegionContainer) {
            updateMode = 3;
        } else if (node instanceof CSSRegionContainer) {
            updateMode = 4;
        } else {
            CSSUtil.debugOut("What's this node? : " + node.getClass().toString());
            return;
        }
        this.fParser.setupUpdateContext(updateMode, parentNode, node);
        CSSNodeImpl prev = this.getOldPrevious(parentNode, node);
        CSSNodeImpl next = this.getOldNext(parentNode, node);
        int insertPos = -1;
        int endPos = -1;
        String source = "";
        if (prev != null) {
            insertPos = prev.getEndOffset();
        } else {
            insertPos = node.getStartOffset();
            insertPos -= this.nearestSpaceLengthBefore(parentNode, insertPos);
        }
        if (next != null) {
            endPos = next.getStartOffset();
        } else {
            endPos = node.getEndOffset();
            endPos += this.nearestSpaceLengthAfter(parentNode, endPos);
        }
        source = this.getSpaceBefore(parentNode, next, node);
        if (source.length() > 0) {
            this.insertText(insertPos, endPos - insertPos, source);
        } else {
            this.removeText(insertPos, endPos - insertPos);
        }
        this.fParser.cleanupUpdateContext();
    }

    void childReplaced(CSSNodeImpl parentNode, CSSNodeImpl newChild, CSSNodeImpl oldChild) {
        if (parentNode == null) {
            return;
        }
        if (oldChild != null) {
            this.childRemoved(parentNode, oldChild);
        }
        if (newChild != null) {
            this.childInserted(parentNode, newChild);
        }
    }

    private StructuredDocumentEvent defaultInserted(CSSNodeImpl parentNode, CSSNodeImpl node) {
        ICSSNode sibling;
        int insertPos = -1;
        String preSpace = "";
        String postSpace = "";
        int length = 0;
        if (insertPos < 0 && (sibling = node.getPreviousSibling()) != null) {
            insertPos = this.getTextEnd(sibling);
        }
        if (insertPos < 0 && (sibling = node.getNextSibling()) != null) {
            insertPos = this.getTextStart(sibling);
        }
        if (insertPos < 0) {
            insertPos = this.getChildInsertPos(parentNode);
        }
        if (insertPos < 0) {
            insertPos = 0;
        }
        length = this.nearestSpaceLengthBefore(parentNode, insertPos);
        insertPos -= length;
        preSpace = this.getSpaceBefore(parentNode, node, null);
        length += this.nearestSpaceLengthAfter(parentNode, insertPos + length);
        postSpace = this.getSpaceBefore(parentNode, node.getNextSibling(), null);
        String text = String.valueOf(preSpace) + node.generateSource().trim() + postSpace;
        return this.insertText(insertPos, length, text);
    }

    private int getChildInsertPos(CSSNodeImpl node) {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)node);
        if (formatter != null) {
            return formatter.getChildInsertPos(node);
        }
        return node.getEndOffset();
    }

    private CSSNodeImpl getOldNext(CSSNodeImpl parentNode, CSSNodeImpl node) {
        CSSNodeImpl child = (CSSNodeImpl)parentNode.getLastChild();
        CSSNodeImpl ret = null;
        while (child != null) {
            if (node.getEndOffset() >= child.getEndOffset()) break;
            ret = child;
            child = (CSSNodeImpl)child.getPreviousSibling();
        }
        return ret;
    }

    private CSSNodeImpl getOldPrevious(CSSNodeImpl parentNode, CSSNodeImpl node) {
        CSSNodeImpl child = (CSSNodeImpl)parentNode.getFirstChild();
        CSSNodeImpl ret = null;
        while (child != null) {
            if (child.getStartOffset() >= node.getStartOffset()) break;
            ret = child;
            child = (CSSNodeImpl)child.getNextSibling();
        }
        return ret;
    }

    private String getSpaceBefore(ICSSNode parentNode, ICSSNode node, ICSSNode toRemove) {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)parentNode);
        if (formatter != null) {
            Region exceptFor = null;
            if (toRemove != null) {
                CSSNodeImpl remove = (CSSNodeImpl)toRemove;
                exceptFor = new Region(remove.getStartOffset(), remove.getEndOffset() - remove.getStartOffset());
            }
            return formatter.formatBefore(parentNode, node, (IRegion)exceptFor).toString();
        }
        return "";
    }

    private int getTextEnd(ICSSNode node) {
        int end = -1;
        if (node != null) {
            if (node instanceof CSSStructuredDocumentRegionContainer) {
                end = ((CSSStructuredDocumentRegionContainer)node).getEndOffset();
            } else if (node instanceof CSSRegionContainer) {
                end = ((CSSRegionContainer)node).getEndOffset();
            }
        }
        return end;
    }

    private int getTextStart(ICSSNode node) {
        int start = -1;
        if (node != null) {
            if (node instanceof CSSStructuredDocumentRegionContainer) {
                start = ((CSSStructuredDocumentRegionContainer)node).getStartOffset();
            } else if (node instanceof CSSRegionContainer) {
                start = ((CSSRegionContainer)node).getStartOffset();
            }
        }
        return start;
    }

    private StructuredDocumentEvent insertText(int start, int oldLength, String text) {
        StructuredDocumentEvent result = null;
        BasicStructuredDocument structuredDocument = (BasicStructuredDocument)this.fModel.getStructuredDocument();
        if (structuredDocument != null) {
            if (text != null && oldLength > 0 && start + oldLength <= structuredDocument.getLength()) {
                String delText = structuredDocument.get(start, oldLength);
                int newLength = text.length();
                int shorterLen = Math.min(oldLength, newLength);
                int stMatchLen = 0;
                while (stMatchLen < shorterLen && text.charAt(stMatchLen) == delText.charAt(stMatchLen)) {
                    ++stMatchLen;
                }
                if (stMatchLen > 0 && stMatchLen < shorterLen && text.charAt(stMatchLen - 1) == '\r' && (text.charAt(stMatchLen) == '\n' || delText.charAt(stMatchLen) == '\n')) {
                    --stMatchLen;
                }
                if (stMatchLen == shorterLen) {
                    if (oldLength < newLength) {
                        oldLength = 0;
                        start += stMatchLen;
                        text = text.substring(stMatchLen);
                    } else if (newLength < oldLength) {
                        oldLength -= stMatchLen;
                        start += stMatchLen;
                        text = null;
                    } else {
                        oldLength = 0;
                        text = null;
                    }
                } else {
                    int edMatchLen = 0;
                    while (stMatchLen + edMatchLen < shorterLen && text.charAt(newLength - edMatchLen - 1) == delText.charAt(oldLength - edMatchLen - 1)) {
                        ++edMatchLen;
                    }
                    if (edMatchLen > 0 && text.charAt(newLength - edMatchLen) == '\n' && (edMatchLen < newLength && text.charAt(newLength - edMatchLen - 1) == '\r' || edMatchLen < oldLength && delText.charAt(oldLength - edMatchLen - 1) == '\r')) {
                        --edMatchLen;
                    }
                    oldLength -= stMatchLen + edMatchLen;
                    start += stMatchLen;
                    text = stMatchLen + edMatchLen < newLength ? text.substring(stMatchLen, newLength - edMatchLen) : null;
                }
            }
            if (oldLength > 0 || text != null) {
                result = structuredDocument.replaceText((Object)this.fModel, start, oldLength, text);
            }
        }
        return result;
    }

    private int nearestSpaceLengthAfter(CSSNodeImpl node, int insertPos) {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)node);
        if (formatter != null) {
            return formatter.getLengthToReformatAfter(node, insertPos);
        }
        return 0;
    }

    private int nearestSpaceLengthBefore(CSSNodeImpl node, int insertPos) {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)node);
        if (formatter != null) {
            return formatter.getLengthToReformatBefore(node, insertPos);
        }
        return 0;
    }

    private StructuredDocumentEvent removeText(int start, int length) {
        StructuredDocumentEvent result = null;
        IStructuredDocument structuredDocument = this.fModel.getStructuredDocument();
        if (structuredDocument != null) {
            result = structuredDocument.replaceText((Object)this.fModel, start, length, new String(""));
        }
        return result;
    }

    void setParser(CSSModelParser parser) {
        this.fParser = parser;
    }

    void valueChanged(CSSNodeImpl node, String oldValue) {
        int oldLength;
        if (!(node instanceof CSSRegionContainer)) {
            CSSUtil.debugOut("Too Bad.." + (node == null ? "null" : node.getClass().toString()));
            return;
        }
        int start = node.getStartOffset();
        if (node.getNodeType() == -1) {
            ICSSAttr attr = (ICSSAttr)((Object)node);
            CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)attr.getOwnerCSSNode());
            if (formatter != null) {
                start = formatter.getAttrInsertPos(attr.getOwnerCSSNode(), attr.getName());
            }
        }
        int n = oldLength = oldValue == null ? 0 : oldValue.length();
        if (node instanceof CSSStructuredDocumentRegionContainer) {
            ((CSSStructuredDocumentRegionContainer)node).setFirstStructuredDocumentRegion(null);
            ((CSSStructuredDocumentRegionContainer)node).setLastStructuredDocumentRegion(null);
        } else if (node instanceof CSSRegionContainer) {
            ((CSSRegionContainer)node).setRangeRegion(null, null, null);
        }
        String newValue = node.generateSource();
        ICSSNode parent = node.getNodeType() == -1 ? ((ICSSAttr)((Object)node)).getOwnerCSSNode() : node.getParentNode();
        this.fParser.setupUpdateContext((short)5, parent, node);
        this.insertText(start, oldLength, newValue);
        this.fParser.cleanupUpdateContext();
    }
}

