/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.SortedSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeFacetVersionDialog
extends Dialog {
    private final IProjectFacet facet;
    private final IProjectFacetVersion oldVersion;
    private IProjectFacetVersion newVersion;
    private final SortedSet<IProjectFacetVersion> availableVersions;
    private Combo versionCombo;

    private ChangeFacetVersionDialog(Shell shell, IProjectFacet facet, IProjectFacetVersion currentVersion, SortedSet<IProjectFacetVersion> availableVersions) {
        super(shell);
        this.facet = facet;
        this.oldVersion = currentVersion;
        this.newVersion = currentVersion;
        this.availableVersions = availableVersions;
    }

    public static IProjectFacetVersion showDialog(Shell shell, IProjectFacet facet, IProjectFacetVersion currentVersion, SortedSet<IProjectFacetVersion> availableVersions) {
        ChangeFacetVersionDialog dialog = new ChangeFacetVersionDialog(shell, facet, currentVersion, availableVersions);
        IProjectFacetVersion selectedVersion = null;
        if (dialog.open() == 0) {
            selectedVersion = dialog.newVersion;
        }
        return selectedVersion;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Resources.dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(2), 5, 5, 5, 10));
        composite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 300));
        Label promptLabel = new Label(composite, 64);
        promptLabel.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2));
        promptLabel.setText(Resources.bind((String)Resources.dialogPrompt, (Object)this.facet.getLabel()));
        Label versionFieldLabel = new Label(composite, 0);
        versionFieldLabel.setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gd(), 8));
        versionFieldLabel.setText(Resources.versionFieldLabel);
        this.versionCombo = new Combo(composite, 12);
        this.versionCombo.setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gd(), 8));
        for (IProjectFacetVersion fv : this.availableVersions) {
            this.versionCombo.add(fv.getVersionString());
            if (fv != this.oldVersion) continue;
            this.versionCombo.select(this.versionCombo.getItemCount() - 1);
        }
        this.versionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChangeFacetVersionDialog.this.handleVersionSelected();
            }
        });
        return composite;
    }

    private void handleVersionSelected() {
        int index = this.versionCombo.getSelectionIndex();
        int i = 0;
        for (IProjectFacetVersion fv : this.availableVersions) {
            if (i == index) {
                this.newVersion = fv;
            }
            ++i;
        }
    }

    private static final class Resources
    extends NLS {
        public static String dialogTitle;
        public static String dialogPrompt;
        public static String versionFieldLabel;

        static {
            Resources.initializeMessages((String)ChangeFacetVersionDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

