/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.gef.part;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.gef.policy.selection.NonResizableSelectionEditPolicy;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.xml.gef.policy.OpenListenerEditPolicy;
import org.eclipse.wb.internal.core.xml.gef.policy.TopSelectionEditPolicy;
import org.eclipse.wb.internal.core.xml.model.AbstractComponentInfo;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.gef.core.CompoundCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractComponentEditPart
extends GraphicalEditPart {
    public static final Point TOP_LOCATION = EnvironmentUtils.IS_MAC ? new Point(20, 28) : new Point(20, 20);
    private final AbstractComponentInfo m_component;

    public AbstractComponentEditPart(AbstractComponentInfo component) {
        this.m_component = component;
        this.setModel((Object)this.m_component);
    }

    public final AbstractComponentInfo getComponent() {
        return this.m_component;
    }

    public void activate() {
        this.refreshVisualsOnModelRefresh();
        super.activate();
    }

    private void refreshVisualsOnModelRefresh() {
        if (!this.m_component.isRoot()) {
            return;
        }
        this.m_component.addBroadcastListener(new ObjectEventListener(){

            public void refreshDispose() throws Exception {
                if (AbstractComponentEditPart.this.isActive()) {
                    this.getFigureCanvas().setDrawCached(true);
                }
            }

            public void refreshed() throws Exception {
                this.getFigureCanvas().setDrawCached(false);
                this.getFigureCanvas().redraw();
                AbstractComponentEditPart.this.refresh();
            }

            private FigureCanvas getFigureCanvas() {
                return (FigureCanvas)AbstractComponentEditPart.this.getViewer().getControl();
            }
        });
    }

    protected Figure createFigure() {
        return new Figure(){

            protected void paintClientArea(Graphics graphics) {
                if (AbstractComponentEditPart.this.m_component.isRoot()) {
                    Image image = AbstractComponentEditPart.this.m_component.getImage();
                    graphics.drawImage(image, 0, 0);
                }
                AbstractComponentEditPart.this.drawCustomBorder(this, graphics);
            }
        };
    }

    protected void drawCustomBorder(Figure figure, Graphics graphics) {
        if (this.shouldDrawDotsBorder()) {
            graphics.setForegroundColor(IColorConstants.gray);
            graphics.setLineStyle(3);
            Rectangle area = figure.getClientArea();
            graphics.drawRectangle(0, 0, area.width - 1, area.height - 1);
        }
    }

    private boolean shouldDrawDotsBorder() {
        return (Boolean)ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

            public Boolean runObject() throws Exception {
                return AbstractComponentEditPart.this.m_component.shouldDrawDotsBorder();
            }
        }, (Object)false);
    }

    protected void refreshVisuals() {
        Rectangle bounds = this.m_component.getBounds();
        if (bounds == null) {
            bounds = new Rectangle();
        }
        if (this.m_component.isRoot()) {
            Point rootLocation = this.getRootLocation();
            bounds = bounds.getCopy().setLocation(rootLocation);
        }
        this.getFigure().setBounds(bounds);
    }

    protected Point getRootLocation() {
        return TOP_LOCATION;
    }

    protected void createEditPolicies() {
        if (this.m_component.isRoot()) {
            this.installEditPolicy("Selection Feedback", (EditPolicy)new TopSelectionEditPolicy(this.m_component));
        } else {
            this.installEditPolicy("Selection Feedback", (EditPolicy)new NonResizableSelectionEditPolicy());
        }
        this.installEditPolicy(new OpenListenerEditPolicy(this.m_component));
    }

    protected void refreshEditPolicies() {
    }

    public CompoundCommand createCompoundCommand() {
        return new CompoundEditCommand((ObjectInfo)this.m_component);
    }

    public void refresh() {
        this.refreshEditPolicies();
        super.refresh();
    }

    protected List<?> getModelChildren() {
        return (List)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<List<?>>(){

            public List<?> runObject() throws Exception {
                return AbstractComponentEditPart.this.m_component.getPresentation().getChildrenGraphical();
            }
        }, Collections.emptyList());
    }
}

