/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.core.controls.flyout.FlyoutControlComposite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.ICommandExceptionHandler;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.DesignComposite;
import org.eclipse.wb.internal.core.editor.actions.SelectSupport;
import org.eclipse.wb.internal.core.utils.Debug;
import org.eclipse.wb.internal.core.xml.Messages;
import org.eclipse.wb.internal.core.xml.editor.DesignContextMenuProvider;
import org.eclipse.wb.internal.core.xml.editor.XmlDesignToolbarHelper;
import org.eclipse.wb.internal.core.xml.editor.actions.DesignPageActions;
import org.eclipse.wb.internal.core.xml.editor.palette.DesignerPalette;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.gef.tree.TreeViewer;

public class XmlDesignComposite
extends DesignComposite {
    private DesignPageActions m_pageActions;
    private XmlDesignToolbarHelper m_toolbarHelper;
    private DesignerPalette m_designerPalette;
    private XmlObjectInfo m_rootObject;
    private DesignComposite.IExtractableControl m_extractablePalette;

    public XmlDesignComposite(Composite parent, int style, IEditorPart editorPart, ICommandExceptionHandler exceptionHandler) {
        super(parent, style, editorPart, exceptionHandler);
    }

    protected void createDesignActions() {
        TreeViewer treeViewer = this.m_componentsComposite.getTreeViewer();
        this.m_pageActions = new DesignPageActions(this.m_editorPart, (IEditPartViewer)treeViewer);
        this.m_viewer.setContextMenu((MenuManager)new DesignContextMenuProvider((IEditPartViewer)this.m_viewer, this.m_pageActions));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XmlDesignComposite.this.m_pageActions.dispose();
            }
        });
    }

    protected void createDesignToolbarHelper() {
        this.m_toolbarHelper = new XmlDesignToolbarHelper(this.m_toolBar);
        this.m_toolbarHelper.initialize(this.m_pageActions, (IEditPartViewer)this.m_viewer);
        this.m_toolbarHelper.fill();
    }

    protected void createPalette(FlyoutControlComposite gefComposite) {
        this.m_designerPalette = new DesignerPalette(gefComposite.getFlyoutParent(), 0, true);
    }

    public void onActivate() {
        this.m_pageActions.installActions();
    }

    public void onDeActivate() {
        this.m_pageActions.uninstallActions();
    }

    public void refresh(ObjectInfo rootObject, IProgressMonitor monitor) {
        this.m_rootObject = (XmlObjectInfo)rootObject;
        monitor.subTask(Messages.XmlDesignComposite_statusGef);
        monitor.worked(1);
        this.m_viewer.setInput((Object)this.m_rootObject);
        this.m_viewer.getControl().setDrawCached(false);
        monitor.subTask(Messages.XmlDesignComposite_statusProperties);
        monitor.worked(1);
        this.m_componentsComposite.setInput((IEditPartViewer)this.m_viewer, (ObjectInfo)this.m_rootObject);
        long start = System.currentTimeMillis();
        monitor.subTask(Messages.XmlDesignComposite_statucPalette);
        monitor.worked(1);
        String toolkitId = this.m_rootObject.getDescription().getToolkit().getId();
        this.m_designerPalette.setInput((IEditPartViewer)this.m_viewer, this.m_rootObject, toolkitId);
        Debug.println((Object)("palette: " + (System.currentTimeMillis() - start)));
        this.m_pageActions.setRoot(this.m_rootObject);
        this.m_toolbarHelper.setRoot(this.m_rootObject);
        this.m_viewersComposite.setRoot((ObjectInfo)this.m_rootObject);
        new SelectSupport(rootObject, (IEditPartViewer)this.m_viewer, (IEditPartViewer)this.m_componentsComposite.getTreeViewer());
    }

    public DesignComposite.IExtractableControl getExtractablePalette() {
        if (this.m_extractablePalette == null) {
            this.m_extractablePalette = new DesignComposite.ExtractableControl(this.m_designerPalette.getControl(), (Composite)this);
        }
        return this.m_extractablePalette;
    }
}

