/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wb.internal.core.wizards.AbstractDesignWizardPage;
import org.eclipse.wb.internal.core.wizards.DesignerNewElementWizard;
import org.eclipse.wb.internal.core.wizards.WizardUtils;

public abstract class AbstractDesignWizard
extends DesignerNewElementWizard {
    private static final String EDITOR_ID = "org.eclipse.wb.core.guiEditor";
    protected AbstractDesignWizardPage m_mainPage;

    public void addPages() {
        if (!this.validateSelection()) {
            return;
        }
        this.m_mainPage = this.createMainPage();
        this.addPage((IWizardPage)this.m_mainPage);
        this.m_mainPage.setInitialSelection(this.getSelection());
    }

    protected abstract AbstractDesignWizardPage createMainPage();

    protected boolean validateSelection() {
        return true;
    }

    public boolean performFinish() {
        boolean canFinish = super.performFinish();
        if (canFinish) {
            this.openEditor();
        }
        return canFinish;
    }

    protected void finishPage(IProgressMonitor monitor) throws Exception {
        this.m_mainPage.createType(monitor);
    }

    public final IJavaElement getCreatedElement() {
        return this.m_mainPage.getCreatedType();
    }

    protected void openEditor() {
        IFile file = (IFile)this.m_mainPage.getModifiedResource();
        this.openEditor(file);
    }

    protected void openEditor(IFile file) {
        this.openResource(file, EDITOR_ID);
    }

    protected final IJavaProject getJavaProject() {
        IStructuredSelection selection = this.getSelection();
        return WizardUtils.getJavaProject(selection);
    }
}

