/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.AbstractBrowseImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.IClasspathImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.JarImageResource;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.JarPackageImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageContainer;

final class JarImageContainer
implements IClasspathImageContainer {
    private final String m_id;
    private final IPackageFragmentRoot m_root;
    private final JarFile m_jarFile;
    private final Map<IPath, JarPackageImageContainer> m_packagePathToEntryMap = Maps.newHashMap();
    private Map<String, ImageInfo> m_nameToImageInfo = Maps.newHashMap();

    public JarImageContainer(String id, IPackageFragmentRoot packageFragmentRoot) throws Exception {
        this.m_id = id;
        this.m_root = packageFragmentRoot;
        IPath jarPath = this.m_root.isExternal() ? this.m_root.getPath() : this.m_root.getResource().getLocation();
        this.m_jarFile = new JarFile(jarPath.toOSString());
        Enumeration<JarEntry> E = this.m_jarFile.entries();
        while (E.hasMoreElements()) {
            JarEntry entry = E.nextElement();
            String entryName = entry.getName();
            Path entryPath = new Path(entryName);
            if (!AbstractBrowseImagePage.isImageExtension(entryPath.getFileExtension())) continue;
            IPath packagePath = entryPath.removeLastSegments(1);
            JarPackageImageContainer packageEntry = this.m_packagePathToEntryMap.get(packagePath);
            if (packageEntry == null) {
                packageEntry = new JarPackageImageContainer(this, packagePath);
                this.m_packagePathToEntryMap.put(packagePath, packageEntry);
            }
            packageEntry.addImageEntry(new JarImageResource(this, (IPath)entryPath));
        }
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_obj.gif");
    }

    public String getName() {
        return this.m_root.getElementName();
    }

    public IImageContainer[] elements() {
        return this.m_packagePathToEntryMap.values().toArray(new IImageContainer[this.m_packagePathToEntryMap.size()]);
    }

    public boolean isEmpty() {
        return this.m_packagePathToEntryMap.isEmpty();
    }

    public void dispose() {
        try {
            this.m_jarFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.disposeJarImages();
    }

    private void disposeJarImages() {
        for (ImageInfo imageInfo : this.m_nameToImageInfo.values()) {
            imageInfo.getImage().dispose();
        }
        this.m_nameToImageInfo = null;
    }

    ImageInfo getImage(String entryName) {
        ImageInfo imageInfo = this.m_nameToImageInfo.get(entryName);
        if (imageInfo == null) {
            Image image;
            ZipEntry entry = this.m_jarFile.getEntry(entryName);
            if (entry == null) {
                return null;
            }
            try {
                InputStream inputStream = this.m_jarFile.getInputStream(entry);
                try {
                    image = new Image((Device)Display.getCurrent(), inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Throwable e) {
                return null;
            }
            imageInfo = new ImageInfo(this.m_id, entryName, image, entry.getSize());
            this.m_nameToImageInfo.put(entryName, imageInfo);
        }
        return imageInfo;
    }
}

