/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette;

import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.EntryInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ToolEntryInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.DesignerPalette;
import org.eclipse.wb.internal.core.editor.palette.model.entry.FactoryEntryInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

final class DesignerPalettePopupActions {
    private static final ImageDescriptor ID_ADD_CATEGORY = DesignerPalettePopupActions.getImageDescription("add_category.gif");
    private static final ImageDescriptor ID_ADD_COMPONENT = DesignerPalettePopupActions.getImageDescription("add_component.gif");
    private static final ImageDescriptor IMPORT_JAR_IMAGE = DesignerPalettePopupActions.getImageDescription("import_jar.png");
    private static final ImageDescriptor ID_REMOVE = DesignerPalettePopupActions.getImageDescription("remove.gif");
    private static final ImageDescriptor ID_MANAGER = DesignerPalettePopupActions.getImageDescription("manager.gif");
    private static final ImageDescriptor ID_SETTINGS = DesignerPalettePopupActions.getImageDescription("settings.png");
    private static final ImageDescriptor ID_IMPORT = DesignerPalettePopupActions.getImageDescription("import.png");
    private static final ImageDescriptor ID_EXPORT = DesignerPalettePopupActions.getImageDescription("export.png");
    private final DesignerPalette.DesignerPaletteOperations m_operations;

    public DesignerPalettePopupActions(DesignerPalette.DesignerPaletteOperations operations) {
        this.m_operations = operations;
    }

    private static ImageDescriptor getImageDescription(String path) {
        return DesignerPlugin.getImageDescriptor((String)("palette/" + path));
    }

    void addPopupActions(IMenuManager menuManager, Object target) {
        if (this.m_operations.canEditPalette()) {
            this.addPopupActions_edit(menuManager, target);
        }
        menuManager.add((IContributionItem)new Separator());
        Action settingsAction = new Action(Messages.DesignerPalettePopupActions_settingsAction, ID_SETTINGS){

            public void run() {
                DesignerPalettePopupActions.this.m_operations.editPreferences();
            }
        };
        menuManager.add((IAction)settingsAction);
    }

    private void addPopupActions_edit(IMenuManager menuManager, Object target) {
        final EntryInfo targetEntry = this.getEntry(target);
        final CategoryInfo targetCategory = this.getCategory(target);
        Action addCategoryAction = new Action(Messages.DesignerPalettePopupActions_addCategoryAction, ID_ADD_CATEGORY){

            public void run() {
                CategoryInfo nextCategory = null;
                if (targetCategory != null) {
                    nextCategory = targetCategory;
                } else if (targetEntry != null) {
                    nextCategory = targetEntry.getCategory();
                }
                DesignerPalettePopupActions.this.m_operations.addCategory(nextCategory);
            }
        };
        menuManager.add((IAction)addCategoryAction);
        Action addComponentAction = new Action(Messages.DesignerPalettePopupActions_addComponentAction, ID_ADD_COMPONENT){

            public void run() {
                CategoryInfo category = targetCategory;
                if (targetEntry != null) {
                    category = targetEntry.getCategory();
                }
                DesignerPalettePopupActions.this.m_operations.addComponent(category);
            }
        };
        menuManager.add((IAction)addComponentAction);
        CategoryInfo category = targetEntry != null ? targetEntry.getCategory() : targetCategory;
        MenuManager staticMenuManager = new MenuManager(Messages.DesignerPalettePopupActions_addStaticFactoryAction);
        menuManager.add((IContributionItem)staticMenuManager);
        IAction action = this.popup_createAction_addFactory(category, true);
        staticMenuManager.add(action);
        action = this.popup_createAction_addFactories(category, true);
        staticMenuManager.add(action);
        MenuManager instanceMenuManager = new MenuManager(Messages.DesignerPalettePopupActions_addInstanceFactoryAction);
        menuManager.add((IContributionItem)instanceMenuManager);
        action = this.popup_createAction_addFactory(category, false);
        instanceMenuManager.add(action);
        action = this.popup_createAction_addFactories(category, false);
        instanceMenuManager.add(action);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new Action(Messages.DesignerPalettePopupActions_importJarAction, IMPORT_JAR_IMAGE){

            public void run() {
                CategoryInfo nextCategory = null;
                if (targetCategory != null) {
                    nextCategory = targetCategory;
                } else if (targetEntry != null) {
                    nextCategory = targetEntry.getCategory();
                }
                DesignerPalettePopupActions.this.m_operations.importJar(nextCategory);
            }
        });
        menuManager.add((IContributionItem)new Separator());
        Action editAction = new Action(Messages.DesignerPalettePopupActions_editAction){

            public void run() {
                if (targetCategory != null) {
                    DesignerPalettePopupActions.this.m_operations.editCategory(targetCategory);
                } else if (targetEntry instanceof ToolEntryInfo) {
                    DesignerPalettePopupActions.this.m_operations.editEntry((ToolEntryInfo)targetEntry);
                }
            }
        };
        menuManager.add((IAction)editAction);
        editAction.setEnabled(targetCategory != null || targetEntry instanceof ComponentEntryInfo || targetEntry instanceof FactoryEntryInfo);
        Action removeAction = new Action(Messages.DesignerPalettePopupActions_removeAction, ID_REMOVE){

            public void run() {
                if (targetEntry != null) {
                    if (MessageDialog.openConfirm((Shell)DesignerPalettePopupActions.this.getShell(), (String)Messages.DesignerPalettePopupActions_removeEntryTitle, (String)MessageFormat.format(Messages.DesignerPalettePopupActions_removeEntryMessage, targetEntry.getName()))) {
                        DesignerPalettePopupActions.this.m_operations.removeEntry(targetEntry);
                    }
                } else if (targetCategory != null && MessageDialog.openConfirm((Shell)DesignerPalettePopupActions.this.getShell(), (String)Messages.DesignerPalettePopupActions_removeCategoryTitle, (String)MessageFormat.format(Messages.DesignerPalettePopupActions_removeCategoryMessage, targetCategory.getName()))) {
                    DesignerPalettePopupActions.this.m_operations.removeCategory(targetCategory);
                }
            }
        };
        menuManager.add((IAction)removeAction);
        removeAction.setEnabled(targetEntry != null || targetCategory != null);
        menuManager.add((IContributionItem)new Separator());
        Action defaultAction = new Action(Messages.DesignerPalettePopupActions_restoreDefaultsAction){

            public void run() {
                if (MessageDialog.openConfirm((Shell)DesignerPalettePopupActions.this.getShell(), (String)Messages.DesignerPalettePopupActions_restoreDefaultsTitle, (String)Messages.DesignerPalettePopupActions_restoreDefaultsMessage)) {
                    DesignerPalettePopupActions.this.m_operations.defaultPalette();
                }
            }
        };
        menuManager.add((IAction)defaultAction);
        Action managerAction = new Action(Messages.DesignerPalettePopupActions_managerAction, ID_MANAGER){

            public void run() {
                DesignerPalettePopupActions.this.m_operations.editPalette();
            }
        };
        menuManager.add((IAction)managerAction);
        this.addImportExport(menuManager);
    }

    private IAction popup_createAction_addFactory(final CategoryInfo category, final boolean forStatic) {
        return new Action(Messages.DesignerPalettePopupActions_factorySingleAction){

            public void run() {
                DesignerPalettePopupActions.this.m_operations.addFactory(category, forStatic);
            }
        };
    }

    private IAction popup_createAction_addFactories(final CategoryInfo category, final boolean forStatic) {
        return new Action(Messages.DesignerPalettePopupActions_factoryMultipleAction){

            public void run() {
                DesignerPalettePopupActions.this.m_operations.addFactories(category, forStatic);
            }
        };
    }

    private void addImportExport(IMenuManager menuManager) {
        Action importAction = new Action(Messages.DesignerPalettePopupActions_importAction, ID_IMPORT){

            public void run() {
                DesignerPalettePopupActions.this.importPalette();
            }
        };
        Action exportAction = new Action(Messages.DesignerPalettePopupActions_exportAction, ID_EXPORT){

            public void run() {
                DesignerPalettePopupActions.this.exportPalette();
            }
        };
        menuManager.add((IAction)importAction);
        menuManager.add((IAction)exportAction);
    }

    private void exportPalette() {
        final String path = this.getImportExportPath(8192);
        if (path != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    DesignerPalettePopupActions.this.m_operations.exportPalette(path);
                }
            });
        }
    }

    private void importPalette() {
        final String path = this.getImportExportPath(4096);
        if (path != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    DesignerPalettePopupActions.this.m_operations.importPalette(path);
                }
            });
        }
    }

    private String getImportExportPath(int style) {
        FileDialog fileDialog = new FileDialog(this.getShell(), style);
        fileDialog.setFilterExtensions(new String[]{"*.xml"});
        fileDialog.setFilterNames(new String[]{Messages.DesignerPalettePopupActions_paletteFilterName});
        fileDialog.setFileName(String.valueOf(this.m_operations.getToolkitId()) + ".xml");
        return fileDialog.open();
    }

    private Shell getShell() {
        return this.m_operations.getShell();
    }

    private CategoryInfo getCategory(Object target) {
        return this.m_operations.getCategory(target);
    }

    private EntryInfo getEntry(Object target) {
        return this.m_operations.getEntry(target);
    }
}

