/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.multi;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.core.editor.IEditorPage;
import org.eclipse.wb.core.editor.IEditorPageFactory;
import org.eclipse.wb.core.editor.IMultiMode;
import org.eclipse.wb.internal.core.editor.DesignPage;
import org.eclipse.wb.internal.core.editor.multi.DesignerEditor;
import org.eclipse.wb.internal.core.editor.multi.SourcePage;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

public abstract class MultiMode
implements IMultiMode {
    protected final DesignerEditor m_editor;
    protected final SourcePage m_sourcePage;
    protected final DesignPage m_designPage;
    protected final List<IEditorPage> m_additionalPages = Lists.newArrayList();

    public MultiMode(DesignerEditor editor) {
        this.m_editor = editor;
        this.m_sourcePage = new SourcePage(this.m_editor);
        this.m_designPage = new DesignPage();
    }

    public final SourcePage getSourcePage() {
        return this.m_sourcePage;
    }

    public final DesignPage getDesignPage() {
        return this.m_designPage;
    }

    public abstract boolean isSourceActive();

    public abstract boolean isDesignActive();

    public abstract void showSource();

    public abstract void showDesign();

    public abstract void switchSourceDesign();

    void create(Composite parent) {
        this.m_sourcePage.initialize(this.m_editor);
        this.m_designPage.initialize(this.m_editor);
        List factories = ExternalFactoriesHelper.getElementsInstances(IEditorPageFactory.class, (String)"org.eclipse.wb.core.designPageFactories", (String)"factory");
        for (IEditorPageFactory factory : factories) {
            factory.createPages(this.m_editor, this.m_additionalPages);
        }
        for (IEditorPage page : this.m_additionalPages) {
            page.initialize(this.m_editor);
        }
    }

    abstract void editorActivatedFirstTime();

    abstract void setFocus();

    void dispose() {
        this.m_sourcePage.dispose();
        this.m_designPage.dispose();
        for (IEditorPage page : this.m_additionalPages) {
            page.dispose();
        }
    }

    public abstract void onSetInput();

    public void afterSave() {
    }
}

