/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types;

import java.util.StringJoiner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;

public class LamiProcess
extends LamiData {
    private final @Nullable String fName;
    private final @Nullable Long fPid;
    private final @Nullable Long fTid;
    private final String fString;

    public LamiProcess(@Nullable String name, @Nullable Long pid, @Nullable Long tid) {
        this.fName = name;
        this.fPid = pid;
        this.fTid = tid;
        this.fString = this.generateString();
    }

    public @Nullable String getName() {
        return this.fName;
    }

    public @Nullable Long getPID() {
        return this.fPid;
    }

    public @Nullable Long getTID() {
        return this.fTid;
    }

    private String generateString() {
        Long pid = this.fPid;
        Long tid = this.fTid;
        StringBuilder sb = new StringBuilder();
        if (this.fName != null) {
            sb.append(this.fName);
        }
        if (pid != null || tid != null) {
            sb.append(' ');
            StringJoiner sj = new StringJoiner(", ", "(", ")");
            if (pid != null) {
                sj.add("pid=" + pid.toString());
            }
            if (tid != null) {
                sj.add("tid=" + tid.toString());
            }
            sb.append(sj.toString());
        }
        return sb.toString();
    }

    @Override
    public @NonNull String toString() {
        return this.fString;
    }
}

