/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiComparators;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiProcess;

public class LamiProcessPIDAspect
extends LamiGenericAspect {
    public LamiProcessPIDAspect(String colName, int colIndex) {
        super(String.valueOf(colName) + " (PID)", null, colIndex, false, false);
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiProcess) {
            Long pid = ((LamiProcess)data).getPID();
            if (pid == null) {
                return null;
            }
            return pid.toString();
        }
        return data.toString();
    }

    @Override
    public @Nullable Number resolveNumber(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiProcess) {
            Long pid = ((LamiProcess)data).getPID();
            return pid;
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return LamiComparators.getLongComparator(this::resolveNumber);
    }
}

