/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.link;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;

class LinkedModeManager {
    private static Map<IDocument, LinkedModeManager> fgManagers = new HashMap<IDocument, LinkedModeManager>();
    private Stack<LinkedModeModel> fEnvironments = new Stack();
    private Listener fListener = new Listener();

    LinkedModeManager() {
    }

    public static boolean hasManager(IDocument document) {
        return fgManagers.get(document) != null;
    }

    public static boolean hasManager(IDocument[] documents) {
        IDocument[] iDocumentArray = documents;
        int n = documents.length;
        int n2 = 0;
        while (n2 < n) {
            IDocument document = iDocumentArray[n2];
            if (LinkedModeManager.hasManager(document)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static LinkedModeManager getLinkedManager(IDocument[] documents, boolean force) {
        IDocument document;
        if (documents == null || documents.length == 0) {
            return null;
        }
        HashSet<LinkedModeManager> mgrs = new HashSet<LinkedModeManager>();
        LinkedModeManager mgr = null;
        IDocument[] iDocumentArray = documents;
        int n = documents.length;
        int n2 = 0;
        while (n2 < n) {
            document = iDocumentArray[n2];
            mgr = fgManagers.get(document);
            if (mgr != null) {
                mgrs.add(mgr);
            }
            ++n2;
        }
        if (mgrs.size() > 1) {
            if (force) {
                for (LinkedModeManager m : mgrs) {
                    m.closeAllEnvironments();
                }
            } else {
                return null;
            }
        }
        if (mgrs.isEmpty()) {
            mgr = new LinkedModeManager();
        }
        iDocumentArray = documents;
        n = documents.length;
        int n3 = 0;
        while (n3 < n) {
            document = iDocumentArray[n3];
            fgManagers.put(document, mgr);
            ++n3;
        }
        return mgr;
    }

    public static void cancelManager(IDocument document) {
        LinkedModeManager mgr = fgManagers.get(document);
        if (mgr != null) {
            mgr.closeAllEnvironments();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void left(LinkedModeModel model, int flags) {
        if (this.fEnvironments.contains(model)) ** GOTO lbl5
        return;
        while ((env = this.fEnvironments.pop()) != model) {
            env.exit(0);
lbl5:
            // 2 sources

            if (!this.fEnvironments.isEmpty()) continue;
        }
        if (this.fEnvironments.isEmpty()) {
            this.removeManager();
        }
    }

    private void closeAllEnvironments() {
        while (!this.fEnvironments.isEmpty()) {
            LinkedModeModel env = this.fEnvironments.pop();
            env.exit(0);
        }
        this.removeManager();
    }

    private void removeManager() {
        Iterator<LinkedModeManager> it = fgManagers.values().iterator();
        while (it.hasNext()) {
            if (it.next() != this) continue;
            it.remove();
        }
    }

    /*
     * Loose catch block
     */
    public boolean nestEnvironment(LinkedModeModel model, boolean force) {
        Assert.isNotNull((Object)model);
        while (true) {
            if (!this.fEnvironments.isEmpty()) break block6;
            model.addLinkingListener(this.fListener);
            this.fEnvironments.push(model);
            break;
        }
        catch (Throwable throwable) {
            Assert.isTrue((!this.fEnvironments.isEmpty() ? 1 : 0) != 0);
            throw throwable;
        }
        {
            LinkedModeModel top;
            block8: {
                block7: {
                    block6: {
                        Assert.isTrue((!this.fEnvironments.isEmpty() ? 1 : 0) != 0);
                        return true;
                    }
                    top = this.fEnvironments.peek();
                    if (!model.canNestInto(top)) break block7;
                    model.addLinkingListener(this.fListener);
                    this.fEnvironments.push(model);
                    Assert.isTrue((!this.fEnvironments.isEmpty() ? 1 : 0) != 0);
                    return true;
                }
                if (force) break block8;
                Assert.isTrue((!this.fEnvironments.isEmpty() ? 1 : 0) != 0);
                return false;
            }
            this.fEnvironments.pop();
            top.exit(0);
            continue;
        }
    }

    public LinkedModeModel getTopEnvironment() {
        if (this.fEnvironments.isEmpty()) {
            return null;
        }
        return this.fEnvironments.peek();
    }

    private class Listener
    implements ILinkedModeListener {
        private Listener() {
        }

        @Override
        public void left(LinkedModeModel model, int flags) {
            LinkedModeManager.this.left(model, flags);
        }

        @Override
        public void suspend(LinkedModeModel model) {
        }

        @Override
        public void resume(LinkedModeModel model, int flags) {
        }
    }
}

