/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.persistence;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.persistence.delegates.GsonMapPersistenceDelegate;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerNode;

public class GsonPeerPersistenceDelegate
extends GsonMapPersistenceDelegate {
    public GsonPeerPersistenceDelegate() {
        super("peer");
    }

    public Class<?> getPersistedClass(Object context) {
        return IPeer.class;
    }

    protected Map<String, Object> toMap(Object context) throws IOException {
        IPeer peer = this.getPeer(context);
        if (peer != null) {
            return super.toMap((Object)peer.getAttributes());
        }
        return new HashMap<String, Object>();
    }

    protected Object fromMap(Map<String, Object> map, Object context) throws IOException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry == null) continue;
            attrs.put(entry.getKey(), entry.getValue().toString());
        }
        Peer peer = new Peer(attrs);
        if (context instanceof IPeer || IPeer.class.equals(context)) {
            return peer;
        }
        if (context instanceof Class && ((Class)context).isAssignableFrom(IPeerNode.class)) {
            AtomicReference model = new AtomicReference();
            Runnable runnable = new Runnable((IPeer)peer, model){
                private final /* synthetic */ IPeer val$peer;
                private final /* synthetic */ AtomicReference val$model;
                {
                    this.val$peer = iPeer;
                    this.val$model = atomicReference;
                }

                @Override
                public void run() {
                    String id = this.val$peer.getID();
                    if (id != null) {
                        IPeerNode peerNode = ModelManager.getPeerModel().getService(IPeerModelLookupService.class).lkupPeerModelById(id);
                        if (peerNode == null) {
                            peerNode = new PeerNode(ModelManager.getPeerModel(), this.val$peer);
                            peerNode.setProperty("isghost", true);
                        }
                        this.val$model.set(peerNode);
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            return model.get();
        }
        return null;
    }

    protected IPeer getPeer(Object context) {
        IPeer peer = null;
        if (context instanceof IPeer) {
            peer = (IPeer)context;
        } else if (context instanceof IPeerNode) {
            peer = ((IPeerNode)context).getPeer();
        } else if (context instanceof IPeerNodeProvider) {
            peer = ((IPeerNodeProvider)context).getPeerNode().getPeer();
        }
        return peer;
    }
}

