/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.model.ContainerModelNode;
import org.eclipse.tcf.te.runtime.model.PendingOperationModelNode;
import org.eclipse.tcf.te.runtime.model.contexts.AsyncRefreshableCtxAdapter;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.locator.nodes.PendingOperationNode;

public class LocatorNode
extends ContainerModelNode
implements ILocatorNode {
    private final IAsyncRefreshableCtx refreshableCtxAdapter = new AsyncRefreshableCtxAdapter();

    public LocatorNode(IPeer peer, boolean isStatic) {
        Assert.isNotNull((Object)peer);
        this.setProperty("PeerInstance", peer);
        this.setProperty("staticInstance", isStatic ? peer : null);
        PendingOperationNode pendingNode = new PendingOperationNode();
        pendingNode.setParent(this);
        this.refreshableCtxAdapter.setPendingOperationNode((PendingOperationModelNode)pendingNode);
        this.setChangeEventsEnabled(true);
    }

    public LocatorNode(IPeer peer) {
        this(peer, false);
    }

    public boolean add(IModelNode node) {
        return super.add(node);
    }

    protected final boolean checkThreadAccess() {
        return Protocol.isDispatchThread();
    }

    @Override
    public boolean isDiscovered() {
        final AtomicBoolean isDiscovered = new AtomicBoolean(false);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                isDiscovered.set(LocatorNode.this.getProperty("staticInstance") != LocatorNode.this.getProperty("PeerInstance"));
            }
        });
        return isDiscovered.get();
    }

    @Override
    public boolean isStatic() {
        final AtomicBoolean isStatic = new AtomicBoolean(false);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                isStatic.set(LocatorNode.this.getProperty("staticInstance") != null);
            }
        });
        return isStatic.get();
    }

    @Override
    public IPeer getPeer() {
        return (IPeer)this.getAdapter(IPeer.class);
    }

    @Override
    public IPeer[] getPeers() {
        ArrayList<IPeer> peers = new ArrayList<IPeer>();
        for (ILocatorNode locatorNode : this.getChildren(ILocatorNode.class)) {
            peers.add(locatorNode.getPeer());
        }
        return peers.toArray(new IPeer[peers.size()]);
    }

    public String getName() {
        return this.getPeer().getName();
    }

    public Object getAdapter(final Class adapter) {
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(LocatorNode.this.doGetAdapter(adapter));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return object.get() != null ? object.get() : super.getAdapter(adapter);
    }

    protected Object doGetAdapter(Class<?> adapter) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        if (ILocatorModel.class.isAssignableFrom(adapter)) {
            return ModelManager.getLocatorModel();
        }
        if (IAsyncRefreshableCtx.class.isAssignableFrom(adapter)) {
            return this.refreshableCtxAdapter;
        }
        Object peer = this.getProperty("PeerInstance");
        if (peer != null && adapter.isAssignableFrom(peer.getClass())) {
            return peer;
        }
        return null;
    }

    public String toString() {
        final StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeer peer = LocatorNode.this.getPeer();
                buffer.append(": id=" + peer.getID());
                buffer.append(", name=" + peer.getName());
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        buffer.append(", " + super.toString());
        return buffer.toString();
    }

    public boolean hasChildren() {
        IAsyncRefreshableCtx.QueryState ctxQuery = this.refreshableCtxAdapter.getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT);
        IAsyncRefreshableCtx.QueryState childQuery = this.refreshableCtxAdapter.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST);
        if (ctxQuery == IAsyncRefreshableCtx.QueryState.IN_PROGRESS || ctxQuery == IAsyncRefreshableCtx.QueryState.PENDING) {
            return true;
        }
        if (childQuery == IAsyncRefreshableCtx.QueryState.IN_PROGRESS || childQuery == IAsyncRefreshableCtx.QueryState.PENDING) {
            return true;
        }
        return super.hasChildren();
    }

    public IModelNode[] getChildren() {
        List children = this.getChildren(IModelNode.class);
        IAsyncRefreshableCtx.QueryState ctxQuery = this.refreshableCtxAdapter.getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT);
        IAsyncRefreshableCtx.QueryState childQuery = this.refreshableCtxAdapter.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST);
        if (ctxQuery == IAsyncRefreshableCtx.QueryState.PENDING || childQuery == IAsyncRefreshableCtx.QueryState.PENDING) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ILocatorModelRefreshService service = ModelManager.getLocatorModel().getService(ILocatorModelRefreshService.class);
                    service.refresh(LocatorNode.this, null);
                }
            });
            children.add(this.refreshableCtxAdapter.getPendingOperationNode());
        }
        if (ctxQuery == IAsyncRefreshableCtx.QueryState.IN_PROGRESS || childQuery == IAsyncRefreshableCtx.QueryState.IN_PROGRESS) {
            children.add(this.refreshableCtxAdapter.getPendingOperationNode());
        }
        return children.toArray(new IModelNode[children.size()]);
    }
}

