/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.marker;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IPointSeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.marker.AbstractBaseChartPaintListener;
import org.eclipse.swtchart.extensions.marker.IBaseChartPaintListener;

public class SeriesLabelMarker
extends AbstractBaseChartPaintListener
implements IBaseChartPaintListener {
    public SeriesLabelMarker(BaseChart baseChart) {
        super(baseChart);
    }

    public void paintControl(PaintEvent e) {
        if (this.isDraw()) {
            ISeries[] series;
            BaseChart baseChart = this.getBaseChart();
            ISeriesSet seriesSet = baseChart.getSeriesSet();
            ISeries[] iSeriesArray = series = seriesSet.getSeries();
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries serie = iSeriesArray[n2];
                String label = serie.getId();
                ISeriesSettings seriesSettings = baseChart.getSeriesSettings(label);
                if (seriesSettings.isVisible()) {
                    int symbolSize = 1;
                    if (seriesSettings instanceof IPointSeriesSettings) {
                        symbolSize = ((IPointSeriesSettings)seriesSettings).getSymbolSize();
                    }
                    e.gc.setForeground(this.getForegroundColor());
                    int i = 0;
                    while (i < serie.getXSeries().length) {
                        Point point = serie.getPixelCoordinates(i);
                        Point labelSize = e.gc.textExtent(label);
                        e.gc.drawText(label, (int)((double)point.x - (double)labelSize.x / 2.0), (int)((double)(point.y - labelSize.y) - (double)symbolSize / 2.0), true);
                        ++i;
                    }
                }
                ++n2;
            }
        }
    }
}

