/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;

public abstract class AbstractMandatoryDomainClassConstraint
extends AbstractConstraint {
    private static final String DOMAIN_CLASS_FEATURE = "domainClass";

    public IStatus validate(IValidationContext ctx) {
        Object[] result;
        EStructuralFeature domainClassFeature;
        EObject eObj = ctx.getTarget();
        EMFEventType eventType = ctx.getEventType();
        if (eventType == EMFEventType.NULL && this.isElementContainedInAKnownMetamodel(eObj) && (domainClassFeature = eObj.eClass().getEStructuralFeature(DOMAIN_CLASS_FEATURE)) != null && (result = this.checkError(domainClassFeature, eObj)) != null) {
            return ctx.createFailureStatus(result);
        }
        return ctx.createSuccessStatus();
    }

    private Object[] checkError(EStructuralFeature domainClassFeature, EObject eObj) {
        Object value = eObj.eGet(domainClassFeature);
        if ((value == null || value instanceof String && StringUtil.isEmpty((String)((String)value))) && !this.canHaveNullDomainClass(eObj)) {
            return new Object[0];
        }
        return null;
    }

    protected boolean canHaveNullDomainClass(EObject instance) {
        return false;
    }
}

