/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.InterpretedExpressionVariableTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.description.tool.Let;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class LetTask
extends AbstractOperationTask {
    private Let let;

    public LetTask(CommandContext context, ModelAccessor extPackage, Let let, IInterpreter interpreter) {
        super(context, extPackage, interpreter);
        this.let = let;
    }

    @Override
    public String getLabel() {
        return Messages.LetTask_label;
    }

    @Override
    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        EObject currentTarget = this.getContext().getCurrentTarget();
        Object value = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluate(currentTarget, this.let, (EStructuralFeature)ToolPackage.eINSTANCE.getLet_ValueExpression());
        String variableName = Optional.ofNullable(this.let.getVariableName()).orElse("");
        if (!variableName.isEmpty()) {
            if ("self".equals(variableName) && value instanceof EObject) {
                this.context.setNextPushEObject((EObject)value);
            } else {
                InterpretedExpressionVariableTask childTask = new InterpretedExpressionVariableTask(this.context, this.extPackage, 0, variableName, value, this.interpreter);
                childTask.execute();
            }
        }
    }
}

