/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.repair;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.repair.IRepairParticipant;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionHelper;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.business.internal.migration.resource.session.commands.MigrationCommandExecutor;
import org.eclipse.sirius.business.internal.repair.commands.RestoreModelElementStateCommand;
import org.eclipse.sirius.business.internal.repair.commands.SaveModelElementStateCommand;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.common.tools.api.util.ResourceUtil;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SiriusRepairProcess {
    public static final String ERROR_MSG = Messages.SiriusRepairProcess_errorMsg;
    private static final String QUOTE = "\"";
    private List<IRepairParticipant> repairParticipants = this.getRepairParticipants();
    private IFile file;
    private boolean backup;

    public SiriusRepairProcess(IFile file, boolean backup) {
        this.file = file;
        this.backup = backup;
    }

    private List<IRepairParticipant> getRepairParticipants() {
        IConfigurationElement[] config;
        ArrayList<IRepairParticipant> participants = new ArrayList<IRepairParticipant>();
        IConfigurationElement[] iConfigurationElementArray = config = EclipseUtil.getConfigurationElementsFor((String)"org.eclipse.sirius.repairParticipant");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object contribution = configurationElement.createExecutableExtension("class");
                if (contribution instanceof IRepairParticipant) {
                    participants.add((IRepairParticipant)contribution);
                }
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius", Messages.SiriusRepairProcess_contributionInstantationErrorMsg, (Throwable)e));
            }
            ++n2;
        }
        return participants;
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        URI resourceURI = URI.createPlatformResourceURI((String)this.file.getFullPath().toOSString(), (boolean)true);
        try {
            try {
                monitor.beginTask(Messages.SiriusRepairProcess_inProgressMsg, 1);
                SiriusPlugin.getDefault().setRepairInProgress(true);
                this.repair(resourceURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (CoreException e) {
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", ERROR_MSG, (Throwable)e));
                monitor.done();
                SiriusPlugin.getDefault().setRepairInProgress(false);
            }
        }
        finally {
            monitor.done();
            SiriusPlugin.getDefault().setRepairInProgress(false);
        }
    }

    protected void repair(URI sessionResourceURI, IProgressMonitor monitor) throws CoreException, InterruptedException {
        Session session = null;
        HashMap<IFile, IFile> originalToBackupFiles = new HashMap<IFile, IFile>();
        try {
            try {
                monitor.beginTask("", 4);
                monitor.subTask(Messages.SiriusRepairProcess_loadingModelMsg);
                session = SessionFactory.INSTANCE.createSession(sessionResourceURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                session.setReloadingPolicy(new ReloadingPolicy(){

                    @Override
                    public List<ReloadingPolicy.Action> getActions(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
                        return Collections.emptyList();
                    }
                });
                this.checkCancel(monitor);
                monitor.subTask(Messages.SiriusRepairProcess_openingsessionMsg);
                session.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.checkCancel(monitor);
                monitor.subTask(Messages.SiriusRepairProcess_resolvingReferencesMsg);
                ModelUtils.resolveAll((Resource)session.getSessionResource());
                this.workMonitorAndCheckCancel(monitor, 1);
                List<Resource> fragmentedResources = this.getFragmentedResources(session.getSessionResource());
                SubProgressMonitor monitorForMainModel = new SubProgressMonitor(monitor, fragmentedResources.size() + 1, 4);
                try {
                    monitorForMainModel.beginTask(MessageFormat.format(Messages.SiriusRepairProcess_repairModelMsg, QUOTE, session.getSessionResource().getURI().lastSegment(), QUOTE), 10);
                    if (this.backup) {
                        monitorForMainModel.subTask(Messages.SiriusRepairProcess_backupMsg);
                        originalToBackupFiles.put(this.file, this.backupFile(this.file, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorForMainModel, 1)));
                    }
                    this.checkCancel((IProgressMonitor)monitorForMainModel);
                    this.repairModel(session, session.getSessionResource(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorForMainModel, 9, 4));
                    for (Resource fragment : fragmentedResources) {
                        SubProgressMonitor monitorForFragmentedModel = new SubProgressMonitor((IProgressMonitor)monitorForMainModel, 1, 4);
                        try {
                            monitorForFragmentedModel.beginTask(MessageFormat.format(Messages.SiriusRepairProcess_repairModelMsg, QUOTE, fragment.getURI().lastSegment(), QUOTE), 10);
                            if (this.backup) {
                                monitorForFragmentedModel.subTask(Messages.SiriusRepairProcess_backupMsg);
                                IFile fragmentedFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(fragment.getURI().toPlatformString(true));
                                IFile fragmentedFileBackup = this.backupFile(fragmentedFile, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorForFragmentedModel, 1));
                                originalToBackupFiles.put(fragmentedFile, fragmentedFileBackup);
                            }
                            this.checkCancel((IProgressMonitor)monitorForFragmentedModel);
                            this.repairModel(session, fragment, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorForFragmentedModel, 9, 4));
                        }
                        finally {
                            monitorForFragmentedModel.done();
                        }
                    }
                    Job.getJobManager().join((Object)"org.eclipse.sirius.saveSessionJob", (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorForMainModel, 1));
                    monitorForMainModel.subTask(Messages.SiriusRepairProcess_savingSessionMsg);
                    session.save((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorForMainModel, 1));
                }
                finally {
                    monitorForMainModel.subTask(Messages.SiriusRepairProcess_closingSessionMsg);
                    Job.getJobManager().join((Object)"org.eclipse.sirius.saveSessionJob", (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorForMainModel, 1));
                    session.close((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorForMainModel, 1));
                    monitorForMainModel.done();
                }
            }
            catch (InterruptedException e) {
                if (this.backup) {
                    this.revertAllBackup((IProgressMonitor)new SubProgressMonitor(monitor, 1), originalToBackupFiles);
                }
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void workMonitorAndCheckCancel(IProgressMonitor monitor, int work) throws InterruptedException {
        monitor.worked(work);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void repairModel(Session session, Resource model, IProgressMonitor monitor) throws InterruptedException {
        if (model.getContents().size() > 0) {
            for (IRepairParticipant participant : this.repairParticipants) {
                participant.repairStarted();
            }
            TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
            DAnalysis dAnalysis = (DAnalysis)model.getContents().get(0);
            MigrationCommandExecutor migrationCommandExecutor = new MigrationCommandExecutor();
            EList<DView> ownedViews = dAnalysis.getOwnedViews();
            monitor.beginTask("", 7 * ownedViews.size());
            for (final DView view : ownedViews) {
                for (IRepairParticipant participant : this.repairParticipants) {
                    participant.startRepairOnView(session, view);
                }
                IdentityCommand handleViewCommand = new IdentityCommand(){

                    public void execute() {
                        SiriusRepairProcess.this.handleView(view);
                    }

                    public boolean canUndo() {
                        return false;
                    }
                };
                monitor.subTask(Messages.SiriusRepairProcess_handlingViewMsg);
                migrationCommandExecutor.execute(transactionalEditingDomain, (Command)handleViewCommand);
                monitor.worked(1);
                monitor.subTask(Messages.SiriusRepairProcess_savingElementsStateMsg);
                this.saveModelElementState(view, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.subTask(Messages.SiriusRepairProcess_removingElementsMsg);
                this.removeElements(view, new SubProgressMonitor(monitor, 1));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.subTask(Messages.SiriusRepairProcess_refreshingRepresentationsMsg);
                this.refreshRepresentations(dAnalysis, view);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.subTask(Messages.SiriusRepairProcess_postRefreshMsg);
                this.postRefresh(model);
                monitor.worked(1);
                monitor.subTask(Messages.SiriusRepairProcess_restoringElementStatsMsg);
                this.restoreModelElementState(view, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                for (IRepairParticipant participant : this.repairParticipants) {
                    participant.endRepairOnView();
                }
            }
            for (IRepairParticipant participant : this.repairParticipants) {
                participant.repairCompeleted();
            }
        }
        monitor.done();
    }

    private void revertAllBackup(IProgressMonitor migrationMonitor, Map<IFile, IFile> originalToBackupFiles) {
        try {
            for (Map.Entry<IFile, IFile> originalToBackupFile : originalToBackupFiles.entrySet()) {
                this.revertBackupFile(originalToBackupFile.getKey(), originalToBackupFile.getValue(), migrationMonitor);
            }
        }
        catch (IOException e) {
            SiriusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.sirius", "", (Throwable)e));
        }
    }

    private void postRefresh(Resource resource) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((Resource)resource);
        for (IRepairParticipant participant : this.repairParticipants) {
            participant.postRefreshOperations(transactionalEditingDomain, resource);
        }
    }

    private void restoreModelElementState(DView view, IProgressMonitor monitor) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)view);
        RestoreModelElementStateCommand restoreModelElementStateCommand = new RestoreModelElementStateCommand(view, this.repairParticipants, monitor);
        new MigrationCommandExecutor().execute(domain, (Command)restoreModelElementStateCommand);
    }

    private void informModel(DView view) {
        DAnalysisSessionHelper.updateModelsReferences(view);
    }

    private void informViewpoint(DView view) {
        List<DRepresentation> loadedRepresentations = new DViewQuery(view).getLoadedRepresentations();
        if (loadedRepresentations != null && !loadedRepresentations.isEmpty()) {
            Viewpoint vp;
            DRepresentation representation = loadedRepresentations.get(0);
            RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
            if (description != null && (vp = new RepresentationDescriptionQuery(description).getParentViewpoint()) != null) {
                view.setViewpoint(vp);
            }
            ((DAnalysis)view.eContainer()).getSelectedViews().add((Object)view);
        }
    }

    private void saveModelElementState(DView view, IProgressMonitor monitor) {
        monitor.beginTask(Messages.SiriusRepairProcess_saveModelElementStateMsg, this.repairParticipants.size());
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)view);
        for (IRepairParticipant participant : this.repairParticipants) {
            SaveModelElementStateCommand saveModelElementStateCommand = new SaveModelElementStateCommand(participant, view, (IProgressMonitor)new NullProgressMonitor());
            new MigrationCommandExecutor().execute(transactionalEditingDomain, (Command)saveModelElementStateCommand);
            monitor.worked(1);
        }
        monitor.done();
    }

    private void removeElements(DView view, SubProgressMonitor monitor) {
        monitor.beginTask(Messages.SiriusRepairProcess_removeElementsMsg, this.repairParticipants.size());
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)view);
        for (IRepairParticipant participant : this.repairParticipants) {
            participant.removeElements(view, transactionalEditingDomain, (IProgressMonitor)monitor);
            monitor.worked(1);
        }
        monitor.done();
    }

    private void refreshRepresentations(DAnalysis dAnalysis, DView view) {
        for (IRepairParticipant participant : this.repairParticipants) {
            participant.refreshRepresentations(dAnalysis, view);
        }
    }

    private List<Resource> getFragmentedResources(final Resource modelResource) {
        return new ArrayList<Resource>(Collections2.filter((Collection)modelResource.getResourceSet().getResources(), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource resource) {
                return !resource.equals(modelResource) && resource instanceof AirdResource && resource.getURI().isPlatformResource();
            }
        }));
    }

    private IFile backupFile(IFile fileToBackup, IProgressMonitor monitor) {
        try {
            return ResourceUtil.createBackupFile((IFile)fileToBackup, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            SiriusPlugin.getDefault().error(Messages.SiriusRepairProcess_bckupCreationErrorMsg, e);
            return null;
        }
    }

    private void revertBackupFile(IFile backupedFile, IFile backupFile, IProgressMonitor monitor) throws IOException {
        try {
            block7: {
                InputStream inpstrBackupFile = backupFile.getContents();
                try {
                    try {
                        backupedFile.setContents(inpstrBackupFile, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        SiriusPlugin.getDefault().error(Messages.SiriusRepairProcess_restoringBckErrorMsg, e);
                        inpstrBackupFile.close();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    inpstrBackupFile.close();
                    throw throwable;
                }
                inpstrBackupFile.close();
            }
            backupFile.delete(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            backupedFile.getParent().refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            SiriusPlugin.getDefault().error(Messages.SiriusRepairProcess_restoringBckErrorMsg, e);
        }
        monitor.done();
    }

    private void handleView(DView view) {
        this.informViewpoint(view);
        this.informModel(view);
        LinkedList<DRepresentation> representationsToRemove = new LinkedList<DRepresentation>();
        for (IRepairParticipant participant : this.repairParticipants) {
            representationsToRemove.addAll(participant.cleanRepresentations((EList<DRepresentation>)ECollections.asEList(new DViewQuery(view).getLoadedRepresentations())));
        }
        this.removeRepresentations(representationsToRemove);
    }

    private void removeRepresentations(List<DRepresentation> representationsToRemove) {
        for (DRepresentation representation : representationsToRemove) {
            SiriusUtil.delete(representation);
        }
    }

    public void dispose() {
        this.file = null;
        this.repairParticipants.clear();
    }
}

