/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.ordering;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.sirius.diagram.business.api.helper.SiriusDiagramUtil;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layout;
import org.eclipse.sirius.diagram.description.OrderedTreeLayout;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrderingProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.ordering.OrderedTreeOrdering;

public class OrderedTreeViewOrderingProvider
implements ViewOrderingProvider {
    private Map<OrderedTreeLayout, OrderedTreeOrdering> orderings = new WeakHashMap<OrderedTreeLayout, OrderedTreeOrdering>();

    @Override
    public ViewOrdering getViewOrdering(DiagramElementMapping mapping) {
        AbstractNodeMapping nodeMapping;
        DiagramDescription desc;
        Layout layout;
        if (mapping instanceof AbstractNodeMapping && (layout = (desc = SiriusDiagramUtil.findDiagramDescription((DiagramElementMapping)(nodeMapping = (AbstractNodeMapping)mapping))).getLayout()) instanceof OrderedTreeLayout && ((OrderedTreeLayout)layout).getNodeMapping().contains((Object)mapping)) {
            return this.getOrdering((OrderedTreeLayout)layout);
        }
        return null;
    }

    @Override
    public boolean provides(DiagramElementMapping mapping) {
        AbstractNodeMapping nodeMapping;
        DiagramDescription desc;
        Layout layout;
        return mapping instanceof AbstractNodeMapping && (layout = (desc = SiriusDiagramUtil.findDiagramDescription((DiagramElementMapping)(nodeMapping = (AbstractNodeMapping)mapping))).getLayout()) instanceof OrderedTreeLayout && ((OrderedTreeLayout)layout).getNodeMapping().contains((Object)mapping);
    }

    private OrderedTreeOrdering getOrdering(OrderedTreeLayout layout) {
        if (this.orderings.containsKey(layout)) {
            return this.orderings.get(layout);
        }
        OrderedTreeOrdering ordering = new OrderedTreeOrdering(layout);
        ordering.setUserAwareCapable(true);
        this.orderings.put(layout, ordering);
        return ordering;
    }
}

