/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.provider;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.AbstractEdgeViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrderingHint;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;

public class InlineEdgeLayoutProvider
extends DefaultLayoutProvider {
    private static final Insets DEFAULT_PADDING = new Insets(30, 30, 10, 30);
    protected Map connectionsToMoveEdgeDescriptor = new HashMap();
    private int side;
    private int start;
    private boolean changeNodeHeight;
    private boolean changeNodeWidth;
    private Insets paddings = DEFAULT_PADDING;
    private int alignment = 0;

    public void setSide(int side) {
        this.side = side;
    }

    public int getSide() {
        return this.side;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public void setChangeNodeHeight(boolean changeNodeHeight) {
        this.changeNodeHeight = changeNodeHeight;
    }

    public void setChangeNodeWidth(boolean changeNodeWidth) {
        this.changeNodeWidth = changeNodeWidth;
    }

    public boolean isChangeNodeHeight() {
        return this.changeNodeHeight;
    }

    public boolean isChangeNodeWidth() {
        return this.changeNodeWidth;
    }

    public void setPaddings(Insets paddings) {
        this.paddings = paddings != null ? paddings : DEFAULT_PADDING;
    }

    public Insets getPaddings() {
        return this.paddings;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        switch (this.alignment) {
            case 0: 
            case 64: 
            case 128: {
                break;
            }
            default: {
                this.alignment = 0;
            }
        }
    }

    @Override
    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        CompoundCommand cc = new CompoundCommand();
        this.connectionsToMoveEdgeDescriptor.clear();
        Map<EditPart, List<EditPart>> containerToChildren = this.split(selectedObjects);
        for (Map.Entry<EditPart, List<EditPart>> currentLayout : containerToChildren.entrySet()) {
            IGraphicalEditPart container = (IGraphicalEditPart)currentLayout.getKey();
            List<EditPart> children = currentLayout.getValue();
            DefaultLayoutProvider.retainType(children, ConnectionEditPart.class);
            AbstractEdgeViewOrdering viewOrdering = ViewOrderingHint.getInstance().consumeEdgeViewOrdering(container.getNotationView());
            Command command = this.createChangeBoundsCommand(children, viewOrdering);
            if (command == null || !command.canExecute()) continue;
            cc.add(command);
        }
        this.connectionsToMoveEdgeDescriptor.clear();
        return cc;
    }

    protected Command createChangeBoundsCommand(List connections, AbstractEdgeViewOrdering viewOrdering) {
        CompoundCommand cc = new CompoundCommand();
        for (IGraphicalEditPart iGraphicalEditPart : this.getNodesEditPart(connections)) {
            ArrayList<ConnectionEditPart> connectionsToInit = new ArrayList<ConnectionEditPart>(iGraphicalEditPart.getSourceConnections().size() + iGraphicalEditPart.getTargetConnections().size());
            connectionsToInit.addAll(iGraphicalEditPart.getSourceConnections());
            connectionsToInit.addAll(iGraphicalEditPart.getTargetConnections());
            DefaultLayoutProvider.retainType(connections, ConnectionEditPart.class);
            this.initEdgesStep(iGraphicalEditPart, viewOrdering, connectionsToInit);
        }
        this.align(viewOrdering);
        for (MoveEdgeDescriptor currentDescriptor : this.connectionsToMoveEdgeDescriptor.values()) {
            Command command = this.createChangeEdgeBoundsCommand(currentDescriptor);
            if (command == null || !command.canExecute()) continue;
            cc.add(command);
        }
        return cc;
    }

    protected Set<EditPart> getNodesEditPart(List<ConnectionEditPart> connections) {
        HashSet<EditPart> result = new HashSet<EditPart>();
        for (ConnectionEditPart connectionEditPart : connections) {
            if (connectionEditPart.getSource() instanceof IGraphicalEditPart) {
                result.add(connectionEditPart.getSource());
            }
            if (!(connectionEditPart.getTarget() instanceof IGraphicalEditPart)) continue;
            result.add(connectionEditPart.getTarget());
        }
        return result;
    }

    protected void initEdgesStep(IGraphicalEditPart connector, AbstractEdgeViewOrdering ordering, List<ConnectionEditPart> connections) {
        Map<View, ConnectionEditPart> viewsToConnections = this.getViews(connections);
        ordering.setConnector(connector.getNotationView());
        ordering.setViews(viewsToConnections.keySet());
        Iterator<View> iterViews = ordering.getSortedViews().iterator();
        int step = 0;
        while (iterViews.hasNext()) {
            View currentView = iterViews.next();
            ConnectionEditPart currentConnection = viewsToConnections.get(currentView);
            MoveEdgeDescriptor moveEdgeDescriptor = (MoveEdgeDescriptor)this.connectionsToMoveEdgeDescriptor.get(currentConnection);
            if (moveEdgeDescriptor == null) {
                moveEdgeDescriptor = new MoveEdgeDescriptor(currentConnection);
                this.connectionsToMoveEdgeDescriptor.put(currentConnection, moveEdgeDescriptor);
            }
            if (connector.getSourceConnections().contains(currentConnection)) {
                moveEdgeDescriptor.setSourceStep(step);
            } else {
                moveEdgeDescriptor.setTargetStep(step);
            }
            ++step;
        }
    }

    @Override
    public boolean provides(IOperation operation) {
        return false;
    }

    protected Command createChangeEdgeBoundsCommand(MoveEdgeDescriptor moveEdgeDescriptor) {
        IGraphicalEditPart graphicalEditPart;
        ConnectionEditPart connectionEditPart = moveEdgeDescriptor.getConnectionEditPart();
        Point sourcePoint = moveEdgeDescriptor.getSourceLocation(true);
        Point targetPoint = moveEdgeDescriptor.getTargetLocation(true);
        PointList points = new PointList(2);
        points.addPoint(sourcePoint);
        points.addPoint(targetPoint);
        Point ref1 = new Point(0, 0);
        Point ref2 = new Point(0, 0);
        FreeformViewport viewport = this.getFreeformViewport(moveEdgeDescriptor.connectionEditPart.getConnectionFigure().getSourceAnchor().getOwner());
        Point delta = viewport.getViewLocation();
        double scale = 1.0;
        if (moveEdgeDescriptor.getConnectionEditPart().getRoot() instanceof DiagramRootEditPart) {
            ZoomManager zoomManager = ((DiagramRootEditPart)moveEdgeDescriptor.getConnectionEditPart().getRoot()).getZoomManager();
            scale = zoomManager.getZoom();
        }
        if (moveEdgeDescriptor.getConnectionEditPart().getSource() instanceof IGraphicalEditPart) {
            graphicalEditPart = (IGraphicalEditPart)moveEdgeDescriptor.getConnectionEditPart().getSource();
            ref1.y = this.getBounds((IGraphicalEditPart)graphicalEditPart).getSize().height / 2;
        }
        if (moveEdgeDescriptor.getConnectionEditPart().getTarget() instanceof IGraphicalEditPart) {
            graphicalEditPart = (IGraphicalEditPart)moveEdgeDescriptor.getConnectionEditPart().getTarget();
            ref2.y = this.getBounds((IGraphicalEditPart)graphicalEditPart).getSize().height / 2;
        }
        Point source = connectionEditPart.getConnectionFigure().getSourceAnchor().getReferencePoint().getTranslated(delta);
        source.x = (int)((double)source.x * 1.0 / scale);
        source.y = (int)((double)source.y * 1.0 / scale);
        Point target = connectionEditPart.getConnectionFigure().getTargetAnchor().getReferencePoint().getTranslated(delta);
        target.x = (int)((double)target.x * 1.0 / scale);
        target.y = (int)((double)target.y * 1.0 / scale);
        SetAllBendpointRequest setAllBendpointRequest = new SetAllBendpointRequest("set_all_connection_bendpoint", points, source, target);
        Command command = this.buildCommandWrapper((Request)setAllBendpointRequest, (EditPart)connectionEditPart);
        if (command != null) {
            command.canExecute();
        }
        return command;
    }

    private FreeformViewport getFreeformViewport(IFigure figure) {
        IFigure current = figure;
        while (!(current instanceof FreeformViewport) && current != null) {
            current = current.getParent();
        }
        return (FreeformViewport)current;
    }

    protected Command createResizeConnectorsCommand() {
        CompoundCommand cc = new CompoundCommand();
        return cc;
    }

    private int computePos(int current) {
        int result = current;
        switch (this.side) {
            case 8: 
            case 16: 
            case 24: {
                result = this.getPaddings().top + (this.getPaddings().top + this.getPaddings().bottom) * current;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                result = this.getPaddings().left + (this.getPaddings().left + this.getPaddings().right) * current;
                break;
            }
        }
        return result;
    }

    private int stepFromPos(int pos) {
        int result = pos;
        switch (this.side) {
            case 8: 
            case 16: 
            case 24: {
                result = (int)((double)(pos - this.getPaddings().top) / ((double)this.getPaddings().top + (double)this.getPaddings().bottom));
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                result = (int)((double)(pos - this.getPaddings().left) / ((double)this.getPaddings().left + (double)this.getPaddings().right));
                break;
            }
        }
        return result;
    }

    private Point computePrimaryPoint(int pos, Rectangle connectorBounds) {
        Point result = new Point();
        block0 : switch (this.getSide()) {
            case 16: {
                result.x = 0;
                switch (this.getStart()) {
                    case 32: {
                        result.y = connectorBounds.height - pos;
                        break block0;
                    }
                    case 16: {
                        result.y = connectorBounds.height / 2 + pos;
                        break block0;
                    }
                }
                result.y = pos;
                break;
            }
            case 8: 
            case 24: {
                result.x = connectorBounds.width;
                switch (this.getStart()) {
                    case 32: {
                        result.y = connectorBounds.height - pos;
                        break block0;
                    }
                    case 16: {
                        result.y = connectorBounds.height / 2 + pos;
                        break block0;
                    }
                }
                result.y = pos;
                break;
            }
            case 1: {
                result.y = 0;
                switch (this.getStart()) {
                    case 4: {
                        result.x = connectorBounds.width - pos;
                        break block0;
                    }
                    case 2: {
                        result.x = connectorBounds.width / 2 + pos;
                        break block0;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                result.y = connectorBounds.height;
                switch (this.getStart()) {
                    case 4: {
                        result.x = connectorBounds.width - pos;
                        break block0;
                    }
                    case 2: {
                        result.x = connectorBounds.width / 2 + pos;
                        break block0;
                    }
                }
                break;
            }
        }
        return result;
    }

    private int posFromPrimaryPoint(Point pt, Rectangle connectorBounds) {
        int result = 0;
        block0 : switch (this.getSide()) {
            case 8: 
            case 16: 
            case 24: {
                switch (this.getStart()) {
                    case 32: {
                        result = connectorBounds.height - pt.y;
                        break block0;
                    }
                    case 16: {
                        result = pt.y - connectorBounds.height / 2;
                        break block0;
                    }
                }
                result = pt.y;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                switch (this.getStart()) {
                    case 4: {
                        result = connectorBounds.width - pt.x;
                        break block0;
                    }
                    case 2: {
                        result = pt.x - connectorBounds.width / 2;
                        break block0;
                    }
                }
                result = pt.x;
                break;
            }
        }
        return result;
    }

    protected void align(AbstractEdgeViewOrdering viewOrdering) {
        switch (this.getAlignment()) {
            case 64: {
                this.horizontalAlign(viewOrdering);
                break;
            }
            case 128: {
                this.verticalAlign(viewOrdering);
            }
        }
    }

    private void verticalAlign(AbstractEdgeViewOrdering viewOrdering) {
        Map connectorsToStepRearrangeMin = this.initConnectorsToStepRearrangeMin();
        boolean again = true;
        while (again) {
            again = false;
            for (MoveEdgeDescriptor currentDescriptor : this.connectionsToMoveEdgeDescriptor.values()) {
                int result;
                int connectorStart;
                IGraphicalEditPart connector;
                Point sourcePoint = currentDescriptor.getSourceLocation(false);
                Point targetPoint = currentDescriptor.getTargetLocation(false);
                if (sourcePoint.y >= targetPoint.y - 29 && sourcePoint.y <= targetPoint.y + 29) continue;
                if (sourcePoint.y < targetPoint.y) {
                    sourcePoint.y = targetPoint.y;
                    currentDescriptor.approximateSourceStep(sourcePoint, false);
                    connector = (IGraphicalEditPart)currentDescriptor.getConnectionEditPart().getSource();
                    connectorStart = (Integer)connectorsToStepRearrangeMin.get(connector.getNotationView());
                    result = this.rearrangeConnector(connector, connectorStart, viewOrdering);
                    connectorsToStepRearrangeMin.put(connector.getNotationView(), result);
                    if (result == connectorStart) continue;
                    again = true;
                    continue;
                }
                targetPoint.y = sourcePoint.y;
                currentDescriptor.approximateTargetStep(targetPoint, false);
                connector = (IGraphicalEditPart)currentDescriptor.getConnectionEditPart().getTarget();
                connectorStart = (Integer)connectorsToStepRearrangeMin.get(connector.getNotationView());
                result = this.rearrangeConnector(connector, connectorStart, viewOrdering);
                connectorsToStepRearrangeMin.put(connector.getNotationView(), result);
                if (result == connectorStart) continue;
                again = true;
            }
        }
    }

    private void horizontalAlign(AbstractEdgeViewOrdering viewOrdering) {
        boolean again = true;
        while (again) {
            again = false;
            for (MoveEdgeDescriptor currentDescriptor : this.connectionsToMoveEdgeDescriptor.values()) {
                Point sourcePoint = currentDescriptor.getSourceLocation(false);
                Point targetPoint = currentDescriptor.getTargetLocation(false);
                if (sourcePoint.x >= targetPoint.x - 10 && sourcePoint.x <= targetPoint.x + 10) continue;
                if (sourcePoint.x < targetPoint.x) {
                    sourcePoint.x = targetPoint.x;
                    currentDescriptor.approximateSourceStep(sourcePoint, false);
                    again = true;
                    continue;
                }
                targetPoint.x = sourcePoint.x;
                currentDescriptor.approximateTargetStep(targetPoint, false);
                again = true;
            }
        }
    }

    private Map initConnectorsToStepRearrangeMin() {
        HashMap<View, Integer> result = new HashMap<View, Integer>();
        for (MoveEdgeDescriptor currentDescriptor : this.connectionsToMoveEdgeDescriptor.values()) {
            View targetConnector;
            View sourceConnector;
            ConnectionEditPart connectionEditPart = currentDescriptor.getConnectionEditPart();
            if (connectionEditPart.getSource() instanceof IGraphicalEditPart && !result.containsKey(sourceConnector = ((IGraphicalEditPart)connectionEditPart.getSource()).getNotationView())) {
                result.put(sourceConnector, 0);
            }
            if (!(connectionEditPart.getTarget() instanceof IGraphicalEditPart) || result.containsKey(targetConnector = ((IGraphicalEditPart)connectionEditPart.getTarget()).getNotationView())) continue;
            result.put(targetConnector, 0);
        }
        return result;
    }

    private int rearrangeConnector(IGraphicalEditPart connector, int connectorStart, AbstractEdgeViewOrdering viewOrdering) {
        int result = connectorStart;
        ArrayList connections = new ArrayList(connector.getSourceConnections().size() + connector.getTargetConnections().size());
        Iterables.addAll(connections, (Iterable)Iterables.filter((Iterable)connector.getSourceConnections(), EditPart.class));
        Iterables.addAll(connections, (Iterable)Iterables.filter((Iterable)connector.getTargetConnections(), EditPart.class));
        Map views = this.getViews(connections);
        viewOrdering.setConnector(connector.getNotationView());
        viewOrdering.setViews(views.keySet());
        List<View> sortedViews = viewOrdering.getSortedViews();
        Iterator<View> iterViews = sortedViews.iterator();
        int current = 0;
        while (iterViews.hasNext()) {
            int step;
            View currentView = iterViews.next();
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)views.get(currentView);
            MoveEdgeDescriptor descriptor = (MoveEdgeDescriptor)this.connectionsToMoveEdgeDescriptor.get(connectionEditPart);
            boolean source = connectionEditPart.getSource().equals(connector);
            if (source) {
                step = descriptor.getSourceStep();
                if (step < current) {
                    step = current;
                }
                if (step > current) {
                    if (result == connectorStart) {
                        result = step + 1;
                    }
                    current = step;
                }
                descriptor.setSourceStep(step);
            } else {
                step = descriptor.getTargetStep();
                if (step < current) {
                    step = current;
                }
                if (step > current) {
                    if (result == connectorStart) {
                        result = step + 1;
                    }
                    current = step;
                }
                descriptor.setTargetStep(step);
            }
            ++current;
        }
        return result;
    }

    protected class MoveEdgeDescriptor {
        private ConnectionEditPart connectionEditPart;
        private int sourceStep;
        private int targetStep;

        public MoveEdgeDescriptor(ConnectionEditPart connectionEditPart) {
            this.connectionEditPart = connectionEditPart;
        }

        public int getSourceStep() {
            return this.sourceStep;
        }

        public int getTargetStep() {
            return this.targetStep;
        }

        public void setSourceStep(int sourceStep) {
            this.sourceStep = sourceStep;
        }

        public void setTargetStep(int targetStep) {
            this.targetStep = targetStep;
        }

        public ConnectionEditPart getConnectionEditPart() {
            return this.connectionEditPart;
        }

        public Point getSourceLocation(boolean relative) {
            int pos = InlineEdgeLayoutProvider.this.computePos(this.sourceStep);
            Rectangle sourceBounds = InlineEdgeLayoutProvider.this.getBounds((IGraphicalEditPart)this.connectionEditPart.getSource());
            Point sourceLocation = InlineEdgeLayoutProvider.this.computePrimaryPoint(pos, sourceBounds);
            if (!relative) {
                sourceLocation.translate(sourceBounds.getLocation());
            }
            return sourceLocation;
        }

        public Point getTargetLocation(boolean relative) {
            int pos = InlineEdgeLayoutProvider.this.computePos(this.targetStep);
            Rectangle targetBounds = InlineEdgeLayoutProvider.this.getBounds((IGraphicalEditPart)this.connectionEditPart.getTarget());
            Point targetLocation = InlineEdgeLayoutProvider.this.computePrimaryPoint(pos, targetBounds);
            if (!relative) {
                targetLocation.translate(targetBounds.getLocation());
            }
            return targetLocation;
        }

        public void approximateSourceStep(Point desiredLocation, boolean relative) {
            Rectangle sourceBounds = InlineEdgeLayoutProvider.this.getBounds((IGraphicalEditPart)this.connectionEditPart.getSource());
            Point location = desiredLocation.getCopy();
            if (!relative) {
                location.x -= sourceBounds.x;
                location.y -= sourceBounds.y;
            }
            int pos = InlineEdgeLayoutProvider.this.posFromPrimaryPoint(location, sourceBounds);
            this.sourceStep = InlineEdgeLayoutProvider.this.stepFromPos(pos);
        }

        public void approximateTargetStep(Point desiredLocation, boolean relative) {
            Rectangle targetBounds = InlineEdgeLayoutProvider.this.getBounds((IGraphicalEditPart)this.connectionEditPart.getTarget());
            Point location = desiredLocation.getCopy();
            if (!relative) {
                location.x -= targetBounds.x;
                location.y -= targetBounds.y;
            }
            int pos = InlineEdgeLayoutProvider.this.posFromPrimaryPoint(location, targetBounds);
            this.targetStep = InlineEdgeLayoutProvider.this.stepFromPos(pos);
        }
    }
}

