/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.UpdateGMFEdgeStyleCommand;

public class EdgeStyleUpdater
extends ResourceSetListenerImpl {
    private static final NotificationFilter LISTENED_FEATURES = NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDEdge_OwnedStyle()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getEdgeStyle_RoutingStyle())));
    private ECrossReferenceAdapter crossReference;

    public EdgeStyleUpdater(TransactionalEditingDomain domain, ECrossReferenceAdapter crossReference) {
        super(LISTENED_FEATURES);
        domain.addResourceSetListener((ResourceSetListener)this);
        this.crossReference = crossReference;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CompoundCommand cc = new CompoundCommand();
        for (Notification notification : event.getNotifications()) {
            EdgeStyle viewpointEdgeStyle = null;
            Edge gmfEdge = null;
            if (notification.getNotifier() instanceof DEdge && notification.getNewValue() instanceof EdgeStyle) {
                viewpointEdgeStyle = (EdgeStyle)notification.getNewValue();
                gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)((DEdge)notification.getNotifier()), this.crossReference);
            } else if (notification.getNotifier() instanceof EdgeStyle && DiagramPackage.eINSTANCE.getEdgeStyle_RoutingStyle().equals(notification.getFeature())) {
                viewpointEdgeStyle = (EdgeStyle)notification.getNotifier();
                gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)((DEdge)viewpointEdgeStyle.eContainer()), this.crossReference);
            }
            if (gmfEdge == null || viewpointEdgeStyle == null) continue;
            cc.append((Command)new UpdateGMFEdgeStyleCommand(this.getTarget(), gmfEdge, viewpointEdgeStyle));
        }
        return cc;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.crossReference = null;
    }
}

