/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.layout;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithm;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithmProvider;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class CustomLayoutAlgorithmProviderRegistry
implements IRegistryEventListener {
    public static final String LAYOUT_ALGORITHM_PROVIDER_EXTENSION_POINT_ID = "org.eclipse.sirius.diagram.ui.customLayoutAlgorithmProvider";
    private static final String LAYOUT_ALGORITHM_PROVIDER_ELEMENT_NAME = "customLayoutProvider";
    private static final String LAYOUT_ALGORITHM_PROVIDER_CLASS_ATTRIBUTE_NAME = "class";
    private Map<IExtension, CustomLayoutAlgorithmProvider> extensionToLayoutAlgorithmProvider;
    private Map<String, CustomLayoutAlgorithm> layoutProviderRegistry;

    public CustomLayoutAlgorithmProviderRegistry(Map<String, CustomLayoutAlgorithm> layoutProviderRegistry) {
        this.layoutProviderRegistry = layoutProviderRegistry;
        this.extensionToLayoutAlgorithmProvider = new HashMap<IExtension, CustomLayoutAlgorithmProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(LAYOUT_ALGORITHM_PROVIDER_EXTENSION_POINT_ID).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void parseExtension(IExtension extension) {
        CustomLayoutAlgorithmProvider layoutAlgorithmProvider = this.extensionToLayoutAlgorithmProvider.get(extension);
        if (layoutAlgorithmProvider == null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (LAYOUT_ALGORITHM_PROVIDER_ELEMENT_NAME.equals(configurationElement.getName())) {
                    try {
                        Object newInstance = configurationElement.createExecutableExtension(LAYOUT_ALGORITHM_PROVIDER_CLASS_ATTRIBUTE_NAME);
                        if (CustomLayoutAlgorithmProvider.class.isAssignableFrom(newInstance.getClass())) {
                            CustomLayoutAlgorithmProvider CustomAlgorithmProvider = (CustomLayoutAlgorithmProvider)newInstance;
                            List<CustomLayoutAlgorithm> customLayoutAlgorithms = CustomAlgorithmProvider.getCustomLayoutAlgorithms();
                            for (CustomLayoutAlgorithm customLayoutAlgorithm : customLayoutAlgorithms) {
                                this.layoutProviderRegistry.put(customLayoutAlgorithm.getId(), customLayoutAlgorithm);
                            }
                        } else {
                            DiagramUIPlugin.getPlugin().error(MessageFormat.format(Messages.LayoutAlgorithmProviderRegistry_badClassType, newInstance.getClass().getName()), null);
                        }
                    }
                    catch (CoreException e) {
                        DiagramUIPlugin.getPlugin().error(MessageFormat.format(Messages.LayoutAlgorithmProviderRegistry_classInitialization, configurationElement.getName()), (Exception)((Object)e));
                    }
                }
                ++n2;
            }
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            CustomLayoutAlgorithmProvider layoutAlgorithmProvider = this.extensionToLayoutAlgorithmProvider.get(extension);
            if (layoutAlgorithmProvider != null) {
                List<CustomLayoutAlgorithm> customLayoutAlgorithms = layoutAlgorithmProvider.getCustomLayoutAlgorithms();
                for (CustomLayoutAlgorithm customLayoutAlgorithm : customLayoutAlgorithms) {
                    this.layoutProviderRegistry.remove(customLayoutAlgorithm.getId());
                }
            }
            this.extensionToLayoutAlgorithmProvider.remove(extension);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }
}

