/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.GaugeCompositeStyle;
import org.eclipse.sirius.diagram.GaugeSection;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractNotSelectableShapeNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.FixedLayoutEditPolicy;
import org.eclipse.sirius.ext.draw2d.figure.ITransparentFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AirStyleDefaultSizeNodeFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.GaugeCompositeFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.GaugeSectionFigure;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.LabelStyle;

public class GaugeCompositeEditPart
extends AbstractNotSelectableShapeNodeEditPart
implements IStyleEditPart {
    public static final int VISUAL_ID = 3006;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public GaugeCompositeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        return new FixedLayoutEditPolicy();
    }

    protected IFigure createNodeShape() {
        GaugeCompositeFigure gauge = new GaugeCompositeFigure();
        EditPart parent = this.getParent();
        if (parent instanceof IDiagramBorderNodeEditPart) {
            DiagramBorderNodeEditPartOperation.updateTransparencyMode((IDiagramBorderNodeEditPart)parent, (ITransparentFigure)gauge);
        }
        this.primaryShape = gauge;
        return this.primaryShape;
    }

    public GaugeCompositeFigure getPrimaryShape() {
        return (GaugeCompositeFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        return new AirStyleDefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new XYLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void refreshVisuals() {
        Node node = (Node)this.getModel();
        EObject element = node.getElement();
        if (element instanceof GaugeCompositeStyle) {
            GaugeCompositeStyle gaugeCompositeStyle = (GaugeCompositeStyle)element;
            GaugeCompositeFigure figure = this.getPrimaryShape();
            while (gaugeCompositeStyle.getSections().size() > figure.getGauges().size()) {
                figure.addGauge();
            }
            Iterator iterSections = gaugeCompositeStyle.getSections().iterator();
            int i = 0;
            while (iterSections.hasNext()) {
                GaugeSection gaugeSection = (GaugeSection)iterSections.next();
                GaugeCompositeEditPart.fillGaugeProperties(gaugeSection, figure.getGaugeAt(i));
                ++i;
            }
            figure.setAlignment(gaugeCompositeStyle.getAlignment().getLiteral());
        }
        DiagramNodeEditPartOperation.refreshFigure(this);
        DiagramElementEditPartOperation.refreshLabelAlignment(((GraphicalEditPart)this.getParent()).getContentPane(), (LabelStyle)element);
        super.refreshVisuals();
        boolean cfr_ignored_0 = this.getParent() instanceof GraphicalEditPart;
    }

    private static void fillGaugeProperties(GaugeSection gaugeSection, GaugeSectionFigure gaugeFigure) {
        if (gaugeSection.getBackgroundColor() != null) {
            gaugeFigure.setBackgroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(gaugeSection.getBackgroundColor()));
        }
        if (gaugeSection.getForegroundColor() != null) {
            gaugeFigure.setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(gaugeSection.getForegroundColor()));
        }
        int minValue = 0;
        if (gaugeSection.getMin() != null) {
            minValue = gaugeSection.getMin();
        }
        int maxValue = 0;
        if (gaugeSection.getMax() != null) {
            maxValue = gaugeSection.getMax();
        }
        gaugeFigure.setLabel(gaugeSection.getLabel());
        gaugeFigure.setMin(minValue);
        gaugeFigure.setMax(maxValue);
        Integer value = gaugeSection.getValue();
        if (value == null) {
            gaugeFigure.setValue(minValue);
        } else {
            gaugeFigure.setValue(value.intValue());
        }
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    protected Class<?> getMetamodelType() {
        return GaugeCompositeStyle.class;
    }
}

