/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields;

import java.util.function.Predicate;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.JavaProjectContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.PackageContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.SourceFolderContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.TranslationStoreContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.TypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.ResourceTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eScoutTier;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public final class FieldToolkit {
    private FieldToolkit() {
    }

    public static StyledTextField createStyledTextField(Composite parent, String label, int type) {
        return FieldToolkit.createStyledTextField(parent, label, type, 150);
    }

    public static StyledTextField createStyledTextField(Composite parent, String label, int type, int labelWidth) {
        StyledTextField styledTextField = new StyledTextField(parent, type, labelWidth);
        styledTextField.setLabelText(label);
        return styledTextField;
    }

    public static ResourceTextField createResourceField(Composite parent, String label, int type) {
        return FieldToolkit.createResourceField(parent, label, type, 150);
    }

    public static ResourceTextField createResourceField(Composite parent, String label, int type, int labelWidth) {
        ResourceTextField field = new ResourceTextField(parent, type, labelWidth);
        field.setLabelText(label);
        return field;
    }

    public static ProposalTextField createProposalField(Composite parent, String label) {
        return FieldToolkit.createProposalField(parent, label, 1);
    }

    public static ProposalTextField createProposalField(Composite parent, String label, int type) {
        return FieldToolkit.createProposalField(parent, label, type, 150);
    }

    public static ProposalTextField createProposalField(Composite parent, String label, int type, int labelWidth) {
        ProposalTextField field = new ProposalTextField(parent, type, labelWidth);
        field.setLabelText(label);
        return field;
    }

    public static Group createGroupBox(Composite parent, String label) {
        Group group = new Group(parent, 16);
        group.setText(label);
        return group;
    }

    public static Button createCheckBox(Composite parent, String label, boolean checkedByDefault) {
        Button btn = new Button(parent, 32);
        btn.setText(label);
        btn.setSelection(checkedByDefault);
        return btn;
    }

    public static ProposalTextField createPackageField(Composite parent, String label, IJavaProject project) {
        return FieldToolkit.createPackageField(parent, label, project, 150);
    }

    public static ProposalTextField createPackageField(Composite parent, String label, IJavaProject project, int labelWidth) {
        return FieldToolkit.createPackageField(parent, label, project, labelWidth, 1);
    }

    public static ProposalTextField createPackageField(Composite parent, String label, IJavaProject project, int labelWidth, int type) {
        ProposalTextField proposalField = FieldToolkit.createProposalField(parent, label, type, labelWidth);
        PackageContentProvider provider = new PackageContentProvider(project);
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        return proposalField;
    }

    public static ProposalTextField createSourceFolderField(Composite parent, String label, ScoutTier tier) {
        return FieldToolkit.createSourceFolderField(parent, label, tier, 150);
    }

    public static ProposalTextField createSourceFolderField(Composite parent, String label, ScoutTier tier, int labelWidth) {
        ProposalTextField proposalField = FieldToolkit.createProposalField(parent, label, 1, labelWidth);
        SourceFolderContentProvider provider = new SourceFolderContentProvider((Predicate<IJavaElement>)S2eScoutTier.wrap((ScoutTier)tier));
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        return proposalField;
    }

    public static ProposalTextField createAbstractTypeProposalField(Composite parent, String label, IJavaProject jp, String baseClassFqn) {
        return FieldToolkit.createAbstractTypeProposalField(parent, label, jp, baseClassFqn, 150);
    }

    public static ProposalTextField createAbstractTypeProposalField(Composite parent, String label, IJavaProject jp, String baseClassFqn, int labelWidth) {
        ProposalTextField proposalField = FieldToolkit.createProposalField(parent, label, 2, labelWidth);
        StrictHierarchyTypeContentProvider provider = new StrictHierarchyTypeContentProvider(jp, baseClassFqn);
        provider.setTypeProposalFilter((Predicate<IType>)new JdtUtils.PublicAbstractPrimaryTypeFilter());
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        proposalField.addHyperlinkListener((IHyperlinkListener)new JavaElementHyperlinkListener(proposalField));
        return proposalField;
    }

    public static ProposalTextField createProjectProposalField(Composite parent, String label) {
        return FieldToolkit.createProjectProposalField(parent, label, null);
    }

    public static ProposalTextField createProjectProposalField(Composite parent, String label, Predicate<IJavaProject> filter) {
        return FieldToolkit.createProjectProposalField(parent, label, filter, 150);
    }

    public static ProposalTextField createProjectProposalField(Composite parent, String label, Predicate<IJavaProject> filter, int labelWidth) {
        ProposalTextField proposalField = FieldToolkit.createProposalField(parent, label, 1, labelWidth);
        JavaProjectContentProvider provider = new JavaProjectContentProvider();
        provider.setFilter(filter);
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        return proposalField;
    }

    public static ProposalTextField createTranslationStoreProposalField(Composite parent, String label, TranslationStoreStack stack) {
        return FieldToolkit.createTranslationStoreProposalField(parent, label, stack, 150);
    }

    public static ProposalTextField createTranslationStoreProposalField(Composite parent, String label, TranslationStoreStack stack, int labelWidth) {
        ProposalTextField proposalField = FieldToolkit.createProposalField(parent, label, 1, labelWidth);
        TranslationStoreContentProvider provider = new TranslationStoreContentProvider(stack);
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        return proposalField;
    }

    public static ProposalTextField createTypeProposalField(Composite parent, String label, IJavaProject jp) {
        return FieldToolkit.createTypeProposalField(parent, label, jp, 150);
    }

    public static ProposalTextField createTypeProposalField(Composite parent, String label, IJavaProject jp, int labelWidth) {
        ProposalTextField proposalField = FieldToolkit.createProposalField(parent, label, 2, labelWidth);
        TypeContentProvider provider = new TypeContentProvider(jp);
        provider.setTypeProposalFilter((Predicate<IType>)new JdtUtils.PublicPrimaryTypeFilter());
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        proposalField.addHyperlinkListener((IHyperlinkListener)new JavaElementHyperlinkListener(proposalField));
        return proposalField;
    }

    protected static final class JavaElementHyperlinkListener
    extends HyperlinkAdapter {
        private final ProposalTextField m_owner;

        public JavaElementHyperlinkListener(ProposalTextField owner) {
            this.m_owner = owner;
        }

        public void linkActivated(HyperlinkEvent e) {
            Object proposal = this.m_owner.getSelectedProposal();
            if (proposal instanceof IJavaElement) {
                S2eUiUtils.openInEditor((IJavaElement)proposal, false);
            }
        }
    }
}

