/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.resources;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.files.ui.resources.ISystemRemoteManager;
import org.eclipse.rse.files.ui.resources.ISystemRemoteMarker;
import org.eclipse.rse.files.ui.resources.ISystemRemoteMarkerSetElement;
import org.eclipse.rse.files.ui.resources.ISystemRemoteResource;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteMarker;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteMarkerInfo;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteMarkerSet;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteMarkerTypeDefinitionCache;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteResource;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteResourceInfo;

public class SystemRemoteMarkerManager
implements ISystemRemoteManager {
    private static SystemRemoteMarkerManager instance;
    private SystemRemoteMarkerTypeDefinitionCache cache = new SystemRemoteMarkerTypeDefinitionCache();
    private long nextMarkerId = 0L;
    private static final SystemRemoteMarkerInfo[] NO_MARKER_INFO;
    private static final ISystemRemoteMarker[] NO_MARKER;

    static {
        NO_MARKER_INFO = new SystemRemoteMarkerInfo[0];
        NO_MARKER = new ISystemRemoteMarker[0];
    }

    private SystemRemoteMarkerManager() {
    }

    public static SystemRemoteMarkerManager getInstance() {
        if (instance == null) {
            instance = new SystemRemoteMarkerManager();
        }
        return instance;
    }

    public SystemRemoteMarkerTypeDefinitionCache getCache() {
        return this.cache;
    }

    public long getNextMarkerId() {
        return this.nextMarkerId++;
    }

    public void add(ISystemRemoteResource resource, SystemRemoteMarkerInfo[] newMarkers) {
        SystemRemoteMarkerSet markers;
        if (newMarkers.length == 0) {
            return;
        }
        SystemRemoteResource target = (SystemRemoteResource)resource;
        SystemRemoteResourceInfo info = target.getResourceInfo();
        if (info == null) {
            return;
        }
        if (this.isPersistent(newMarkers)) {
            info.set(4096);
        }
        if ((markers = info.getMarkers()) == null) {
            markers = new SystemRemoteMarkerSet(newMarkers.length);
        }
        this.basicAdd(resource, markers, newMarkers);
        if (!markers.isEmpty()) {
            info.setMarkers(markers);
        }
    }

    private void basicAdd(ISystemRemoteResource resource, SystemRemoteMarkerSet markers, SystemRemoteMarkerInfo[] newMarkers) {
        int i = 0;
        while (i < newMarkers.length) {
            SystemRemoteMarkerInfo newMarker = newMarkers[i];
            newMarker.setId(this.getNextMarkerId());
            markers.add(newMarker);
            ++i;
        }
    }

    public void removeMarker(ISystemRemoteResource resource, long id) {
        SystemRemoteMarkerInfo markerInfo = this.findMarkerInfo(resource, id);
        if (markerInfo == null) {
            return;
        }
        SystemRemoteResourceInfo info = ((SystemRemoteResource)resource).getResourceInfo();
        if (info == null) {
            return;
        }
        SystemRemoteMarkerSet markers = info.getMarkers();
        int size = markers.size();
        markers.remove(markerInfo);
        if (markers.size() == 0) {
            info.setMarkers(null);
        }
        if (markers.size() != size && this.isPersistent(markerInfo)) {
            info.set(4096);
        }
    }

    public SystemRemoteMarkerInfo findMarkerInfo(ISystemRemoteResource resource, long id) {
        SystemRemoteResourceInfo info = ((SystemRemoteResource)resource).getResourceInfo();
        if (info == null) {
            return null;
        }
        SystemRemoteMarkerSet markers = info.getMarkers();
        if (markers == null) {
            return null;
        }
        return (SystemRemoteMarkerInfo)markers.get(id);
    }

    public void removeMarkers(ISystemRemoteResource resource, String type, boolean includeSubtypes) {
        SystemRemoteResourceInfo info = ((SystemRemoteResource)resource).getResourceInfo();
        if (info == null) {
            return;
        }
        SystemRemoteMarkerSet markers = info.getMarkers();
        if (markers == null) {
            return;
        }
        if (type == null) {
            ISystemRemoteMarkerSetElement[] matching = markers.elements();
            info.setMarkers(null);
        } else {
            ISystemRemoteMarkerSetElement[] matching = this.basicFindMatching(markers, type, includeSubtypes);
            if (matching.length == 0) {
                return;
            }
            markers.removeAll(matching);
            if (markers.size() == 0) {
                info.setMarkers(null);
            }
        }
    }

    private SystemRemoteMarkerInfo[] basicFindMatching(SystemRemoteMarkerSet markers, String type, boolean includeSubtypes) {
        int size = markers.size();
        if (size <= 0) {
            return NO_MARKER_INFO;
        }
        ArrayList<SystemRemoteMarkerInfo> result = new ArrayList<SystemRemoteMarkerInfo>(size);
        ISystemRemoteMarkerSetElement[] elements = markers.elements();
        int i = 0;
        while (i < elements.length) {
            SystemRemoteMarkerInfo marker = (SystemRemoteMarkerInfo)elements[i];
            if (type == null) {
                result.add(marker);
            } else if (includeSubtypes) {
                if (this.cache.isSubtype(marker.getType(), type)) {
                    result.add(marker);
                }
            } else if (marker.getType().equals(type)) {
                result.add(marker);
            }
            ++i;
        }
        size = result.size();
        if (size <= 0) {
            return NO_MARKER_INFO;
        }
        return result.toArray(new SystemRemoteMarkerInfo[size]);
    }

    public ISystemRemoteMarker findMarker(ISystemRemoteResource resource, long id) {
        SystemRemoteMarkerInfo info = this.findMarkerInfo(resource, id);
        return info == null ? null : new SystemRemoteMarker(resource, info.getId());
    }

    public ISystemRemoteMarker[] findMarkers(ISystemRemoteResource resource, String type, boolean includeSubtypes) {
        SystemRemoteResourceInfo info = ((SystemRemoteResource)resource).getResourceInfo();
        if (info == null) {
            return NO_MARKER;
        }
        ArrayList result = new ArrayList();
        SystemRemoteMarkerSet markers = info.getMarkers();
        if (markers != null) {
            ISystemRemoteMarkerSetElement[] matching = type == null ? markers.elements() : this.basicFindMatching(markers, type, includeSubtypes);
            this.buildMarkers(resource, matching, result);
        }
        return result.toArray(new ISystemRemoteMarker[result.size()]);
    }

    private void buildMarkers(ISystemRemoteResource resource, ISystemRemoteMarkerSetElement[] markers, ArrayList list) {
        if (markers.length == 0) {
            return;
        }
        list.ensureCapacity(list.size() + markers.length);
        int i = 0;
        while (i < markers.length) {
            list.add(new SystemRemoteMarker(resource, ((SystemRemoteMarkerInfo)markers[i]).getId()));
            ++i;
        }
    }

    public boolean isPersistent(SystemRemoteMarkerInfo info) {
        return this.cache.isPersistent(info.getType());
    }

    public boolean isPersistent(ISystemRemoteMarker marker) {
        return this.cache.isPersistent(marker.getType());
    }

    public boolean isPersistent(SystemRemoteMarkerInfo[] infos) {
        int i = 0;
        while (i < infos.length) {
            if (this.cache.isPersistent(infos[i].getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void startup(IProgressMonitor monitor) {
    }

    public void shutdown(IProgressMonitor monitor) {
    }
}

