/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemActionViewerFilter;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseCopyAction;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SystemCopyRemoteFileAction
extends SystemBaseCopyAction
implements IValidatorRemoteSelection {
    protected IRemoteFile targetFolder;
    protected IRemoteFile targetFileOrFolder = null;
    protected IRemoteFile firstSelection = null;
    protected IRemoteFile firstSelectionParent = null;
    protected IRemoteFile[] files;
    protected Vector copiedFiles = new Vector();
    protected IHost sourceConnection;
    protected IRemoteFileSubSystem ss;
    static /* synthetic */ Class class$0;

    public SystemCopyRemoteFileAction(Shell shell) {
        this(shell, 0);
    }

    SystemCopyRemoteFileAction(Shell shell, int mode) {
        super(shell, mode);
        this.setHelp("org.eclipse.rse.ui.actn0110");
        this.setDialogHelp("org.eclipse.rse.ui.dcrf0000");
    }

    protected void reset() {
        super.reset();
        this.targetFolder = null;
        this.targetFileOrFolder = null;
        this.firstSelection = null;
        this.firstSelectionParent = null;
        this.files = null;
        this.copiedFiles = new Vector();
        this.sourceConnection = null;
        this.ss = null;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            if (!(selectedObject instanceof IRemoteFile)) {
                enable = false;
                continue;
            }
            boolean bl = enable = !((IRemoteFile)selectedObject).getParentRemoteFileSubSystem().isOffline();
        }
        return enable;
    }

    protected String checkForCollision(Shell shell, IProgressMonitor monitor, Object targetContainer, Object oldObject, String oldName) {
        String newName = oldName;
        try {
            this.targetFolder = (IRemoteFile)targetContainer;
            this.ss = this.targetFolder.getParentRemoteFileSubSystem();
            this.targetFileOrFolder = this.ss.getRemoteFileObject(this.targetFolder, oldName, monitor);
            if (this.targetFileOrFolder.exists()) {
                RenameRunnable rr = new RenameRunnable(this.targetFileOrFolder);
                Display.getDefault().syncExec((Runnable)rr);
                newName = rr.getNewName();
            }
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"SystemCopyRemoteFileAction.checkForCollision()", (Throwable)e);
        }
        return newName;
    }

    protected boolean checkForCollision(Shell shell, IProgressMonitor monitor, Object targetContainer, String oldName) {
        try {
            this.targetFolder = (IRemoteFile)targetContainer;
            this.ss = this.targetFolder.getParentRemoteFileSubSystem();
            this.targetFileOrFolder = this.ss.getRemoteFileObject(this.targetFolder, oldName, monitor);
            if (this.targetFileOrFolder.exists()) {
                return true;
            }
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"SystemCopyRemoteFileAction.checkForCollision()", (Throwable)e);
        }
        return false;
    }

    protected boolean doCopy(Object targetContainer, Object oldObject, String newName, IProgressMonitor monitor) throws Exception {
        this.targetFolder = (IRemoteFile)targetContainer;
        IRemoteFile srcFileOrFolder = (IRemoteFile)oldObject;
        IHost targetConnection = this.targetFolder.getHost();
        IHost srcConnection = srcFileOrFolder.getHost();
        boolean ok = false;
        if (targetConnection == srcConnection) {
            this.ss = this.targetFolder.getParentRemoteFileSubSystem();
            this.ss.copy(srcFileOrFolder, this.targetFolder, newName, null);
            ok = true;
            String sep = this.targetFolder.getSeparator();
            String targetFolderName = this.targetFolder.getAbsolutePath();
            if (!targetFolderName.endsWith(sep)) {
                this.copiedFiles.addElement(String.valueOf(targetFolderName) + sep + newName);
            } else {
                this.copiedFiles.addElement(String.valueOf(targetFolderName) + newName);
            }
        } else {
            IRemoteFileSubSystem targetFS = this.targetFolder.getParentRemoteFileSubSystem();
            IRemoteFileSubSystem srcFS = srcFileOrFolder.getParentRemoteFileSubSystem();
            String newPath = String.valueOf(this.targetFolder.getAbsolutePath()) + "/" + newName;
            if (srcFileOrFolder.isFile()) {
                SystemRemoteEditManager mgr = SystemRemoteEditManager.getInstance();
                if (!mgr.doesRemoteEditProjectExist()) {
                    mgr.getRemoteEditProject();
                }
                StringBuffer path = new StringBuffer(mgr.getRemoteEditProjectLocation().makeAbsolute().toOSString());
                path = path.append("/" + srcFS.getSystemProfileName() + "/" + srcFS.getHostAliasName() + "/");
                String absolutePath = srcFileOrFolder.getAbsolutePath();
                int colonIndex = absolutePath.indexOf(58);
                if (colonIndex != -1) {
                    absolutePath = colonIndex == 0 ? absolutePath.substring(1) : (colonIndex == absolutePath.length() - 1 ? absolutePath.substring(0, colonIndex) : String.valueOf(absolutePath.substring(0, colonIndex)) + absolutePath.substring(colonIndex + 1));
                }
                path = path.append(absolutePath);
                String tempFile = path.toString();
                srcFS.download(srcFileOrFolder, tempFile, SystemEncodingUtil.ENCODING_UTF_8, null);
                targetFS.upload(tempFile, SystemEncodingUtil.ENCODING_UTF_8, newPath, System.getProperty("file.encoding"), null);
            } else {
                IRemoteFile newTargetFolder = targetFS.getRemoteFileObject(newPath, monitor);
                targetFS.createFolder(newTargetFolder, monitor);
                IRemoteFile[] children = srcFS.list(srcFileOrFolder, monitor);
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        IRemoteFile child = children[i];
                        monitor.subTask("copying " + child.getName());
                        this.doCopy(newTargetFolder, child, child.getName(), monitor);
                        monitor.worked(1);
                        ++i;
                    }
                }
            }
        }
        return ok;
    }

    protected SystemSimpleContentElement getTreeModel() {
        return null;
    }

    protected SystemSimpleContentElement getTreeInitialSelection() {
        return null;
    }

    protected Object[] getOldObjects() {
        return this.getSelectedFiles();
    }

    protected String[] getOldNames() {
        IRemoteFile[] files = this.getSelectedFiles();
        String[] names = new String[files.length];
        int idx = 0;
        while (idx < files.length) {
            names[idx] = files[idx].getName();
            ++idx;
        }
        return names;
    }

    protected String[] getOldAbsoluteNames() {
        IRemoteFile[] files = this.getSelectedFiles();
        String[] names = new String[files.length];
        int idx = 0;
        while (idx < files.length) {
            names[idx] = files[idx].getAbsolutePath();
            ++idx;
        }
        return names;
    }

    protected Dialog createDialog(Shell shell) {
        ++this.runCount;
        if (this.runCount > 1) {
            this.reset();
        }
        String dlgTitle = this.mode == 0 ? SystemResources.RESID_COPY_TITLE : SystemResources.RESID_MOVE_TITLE;
        this.firstSelection = this.getFirstSelectedFile();
        this.sourceConnection = this.firstSelection.getHost();
        SystemRemoteFolderDialog dlg = new SystemRemoteFolderDialog(shell, dlgTitle, this.sourceConnection);
        dlg.setNeedsProgressMonitor(true);
        dlg.setMessage(this.getPromptString());
        dlg.setShowPropertySheet(true, false);
        dlg.setDefaultSystemConnection(this.sourceConnection, true);
        if (this.mode == 1) {
            dlg.setSelectionValidator(this);
        }
        this.firstSelectionParent = this.firstSelection.getParentRemoteFile();
        boolean supportsArchiveManagement = this.firstSelectionParent.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement();
        if (supportsArchiveManagement) {
            SystemActionViewerFilter _filter = new SystemActionViewerFilter();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] types = classArray;
            _filter.addFilterCriterion(types, "isDirectory", "true");
            _filter.addFilterCriterion(types, "isArchive", "true");
            dlg.setCustomViewerFilter(_filter);
        }
        dlg.setPreSelection(this.firstSelectionParent);
        IStructuredSelection sel = this.getSelection();
        if (sel.size() == 1) {
            String singleTitle = null;
            singleTitle = this.mode == 0 ? SystemResources.RESID_COPY_SINGLE_TITLE : SystemResources.RESID_MOVE_SINGLE_TITLE;
            if (!singleTitle.startsWith("Missing")) {
                dlg.setTitle(singleTitle);
            }
        }
        return dlg;
    }

    protected Object getTargetContainer(Dialog dlg) {
        ISubSystem targetSubSystem;
        ISubSystemConfiguration factory;
        SystemRemoteFolderDialog cpyDlg = (SystemRemoteFolderDialog)dlg;
        Object targetContainer = null;
        if (!cpyDlg.wasCancelled() && (targetContainer = cpyDlg.getSelectedObject()) instanceof ISystemFilterReference && (factory = (targetSubSystem = ((ISystemFilterReference)targetContainer).getSubSystem()).getSubSystemConfiguration()).supportsDropInFilters()) {
            targetContainer = targetSubSystem.getTargetForFilter((ISystemFilterReference)targetContainer);
        }
        return targetContainer;
    }

    private void invalidateFilterReferences(IRemoteFile targetFolder) {
        String path = targetFolder.getAbsolutePath();
        IRemoteFileSubSystem fileSS = targetFolder.getParentRemoteFileSubSystem();
        ISystemFilterPoolReferenceManager mgr = fileSS.getSystemFilterPoolReferenceManager();
        ISystemFilterPool[] pools = mgr.getReferencedSystemFilterPools();
        NullProgressMonitor monitor = new NullProgressMonitor();
        int i = 0;
        while (i < pools.length) {
            ISystemFilterPool pool = pools[i];
            ISystemFilter[] filters = pool.getSystemFilters();
            int f = 0;
            while (f < filters.length) {
                String[] strs = filters[f].getFilterStrings();
                int s = 0;
                while (s < strs.length) {
                    String str = strs[s];
                    int lastSep = str.lastIndexOf(fileSS.getSeparator());
                    if (lastSep > 0) {
                        str = str.substring(0, lastSep);
                    }
                    IRemoteFile par = null;
                    try {
                        par = fileSS.getRemoteFileObject(str, (IProgressMonitor)monitor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (par != null) {
                        str = par.getAbsolutePath();
                    }
                    if (str.equals(path)) {
                        ISystemFilterReference ref = mgr.getSystemFilterReference((ISubSystem)fileSS, filters[f]);
                        ref.markStale(true);
                    }
                    ++s;
                }
                ++f;
            }
            ++i;
        }
    }

    public void copyComplete(String operation) {
        if (this.copiedFiles.size() == 0) {
            return;
        }
        IRemoteFileSubSystem fileSS = this.targetFolder.getParentRemoteFileSubSystem();
        Viewer originatingViewer = this.getViewer();
        this.targetFolder.markStale(true);
        this.invalidateFilterReferences(this.targetFolder);
        if (operation == null) {
            operation = "COPY";
        }
        RSECorePlugin.getTheSystemRegistry().fireRemoteResourceChangeEvent(operation, 1, (Object)this.copiedFiles, (Object)this.targetFolder.getAbsolutePath(), (ISubSystem)fileSS, this.getOldAbsoluteNames(), (Object)originatingViewer);
    }

    protected IRemoteFile[] getSelectedFiles() {
        if (this.files == null) {
            IStructuredSelection selection = this.getSelection();
            this.files = new IRemoteFile[selection.size()];
            Iterator i = selection.iterator();
            int idx = 0;
            while (i.hasNext()) {
                this.files[idx++] = (IRemoteFile)i.next();
            }
        }
        return this.files;
    }

    protected IRemoteFile getFirstSelectedFile() {
        if (this.files == null) {
            this.getSelectedFiles();
        }
        if (this.files.length > 0) {
            return this.files[0];
        }
        return null;
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        return null;
    }

    public static class RenameRunnable
    implements Runnable {
        private IRemoteFile _targetFileOrFolder;
        private String _newName;

        public RenameRunnable(IRemoteFile targetFileOrFolder) {
            this._targetFileOrFolder = targetFileOrFolder;
        }

        public void run() {
            ISystemValidator validator = null;
            SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(null, true, (Object)this._targetFileOrFolder, validator);
            dlg.open();
            this._newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
        }

        public String getNewName() {
            return this._newName;
        }
    }
}

