/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunIBeforeTestExtensions
extends AbstractStatementWithScreenshot {
    private static final Logger log = Logger.getLogger(RunIBeforeTestExtensions.class);
    private final List<IBeforeTest> befores;

    public RunIBeforeTestExtensions(String config, Statement next, TestClass testClass, FrameworkMethod method, Object target, List<IBeforeTest> befores) {
        super(config, next, testClass, method, target);
        this.befores = befores;
    }

    public void evaluate() throws Throwable {
        Object before = null;
        log.debug("Run before test extensions for test class " + this.testClass.getJavaClass().getName());
        try {
            for (IBeforeTest bfr : this.befores) {
                before = bfr;
                if (!before.hasToRun()) continue;
                log.debug("Run method runBeforeTest() of class " + before.getClass().getCanonicalName());
                before.runBeforeTest(this.config, this.target, this.frameworkMethod);
            }
        }
        catch (Throwable e) {
            if (ScreenshotCapturer.shouldCaptureScreenshotOnException(e)) {
                log.error("Run method runBeforeTest() of class " + before.getClass().getCanonicalName() + " failed", e);
                this.createScreenshot("BeforeTestExt", before.getClass());
            }
            throw e;
        }
        this.nextStatement.evaluate();
    }
}

