/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards;

import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AddSyncConfigWizardPage
extends WizardPage {
    private Combo fConfigCombo;
    private String fConfigName;
    private final IProject fProject;

    public AddSyncConfigWizardPage(IProject project) {
        super("CDT AddSyncConfigWizardPage");
        this.fProject = project;
        this.setTitle(Messages.AddSyncConfigWizardPage_title);
        this.setDescription(Messages.AddSyncConfigWizardPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.AddSyncConfigWizardPage_Configuration);
        this.fConfigCombo = new Combo(composite, 8);
        this.fConfigCombo.setItems(this.getConfigurationNames(this.fProject));
        this.fConfigCombo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fConfigCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AddSyncConfigWizardPage.this.fConfigCombo.getSelectionIndex();
                if (index >= 0) {
                    AddSyncConfigWizardPage.this.fConfigName = AddSyncConfigWizardPage.this.fConfigCombo.getItem(index);
                } else {
                    AddSyncConfigWizardPage.this.fConfigName = null;
                }
                AddSyncConfigWizardPage.this.setPageComplete(AddSyncConfigWizardPage.this.validatePage());
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private String[] getConfigurationNames(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo != null) {
            return buildInfo.getConfigurationNames();
        }
        return new String[0];
    }

    public String getBuildConfiguration() {
        return this.fConfigName;
    }

    private boolean validatePage() {
        if (this.fConfigName == null) {
            this.setErrorMessage(Messages.AddSyncConfigWizardPage_A_build_configuration_must_be_selected);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

