/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueFloat;
import org.eclipse.ptp.internal.debug.core.pdi.aif.ValueParent;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFValueFloat
extends ValueParent
implements IAIFValueFloat {
    private ByteBuffer byteBuffer;

    public AIFValueFloat(IAIFTypeFloat type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
    }

    @Override
    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        byte[] dst = new byte[this.getType().sizeof()];
        int i = 0;
        while (i < dst.length) {
            dst[i] = buffer.get();
            ++i;
        }
        this.byteBuffer = ByteBuffer.wrap(dst, 0, dst.length);
        this.setSize(this.getType().sizeof());
    }

    @Override
    public String getValueString() throws AIFException {
        if (this.isFloat()) {
            return String.valueOf(this.floatValue());
        }
        if (this.isDouble()) {
            return String.valueOf(this.doubleValue());
        }
        return new String(this.byteBuffer.array());
    }

    @Override
    public float floatValue() throws AIFException {
        try {
            float f = this.byteBuffer.getFloat();
            return f;
        }
        catch (BufferUnderflowException e) {
            return 0.0f;
        }
        finally {
            this.byteBuffer.rewind();
        }
    }

    @Override
    public double doubleValue() throws AIFException {
        try {
            double d = this.byteBuffer.getDouble();
            return d;
        }
        catch (BufferUnderflowException e) {
            return 0.0;
        }
        finally {
            this.byteBuffer.rewind();
        }
    }

    @Override
    public boolean isDouble() {
        return this.getType().sizeof() == 8;
    }

    @Override
    public boolean isFloat() {
        return this.getType().sizeof() == 4;
    }
}

