/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.refactor.processors;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.corext.util.Resources;

class ReadOnlyResourceFinder {
    private ReadOnlyResourceFinder() {
    }

    static boolean confirmDeleteOfReadOnlyElements(IModelElement[] modelElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        String queryTitle = RefactoringCoreMessages.ReadOnlyResourceFinder_0;
        String question = RefactoringCoreMessages.ReadOnlyResourceFinder_1;
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(queryTitle, question, modelElements, resources, queries);
    }

    static boolean confirmMoveOfReadOnlyElements(IModelElement[] modelElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        String queryTitle = RefactoringCoreMessages.ReadOnlyResourceFinder_2;
        String question = RefactoringCoreMessages.ReadOnlyResourceFinder_3;
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(queryTitle, question, modelElements, resources, queries);
    }

    private static boolean confirmOperationOnReadOnlyElements(String queryTitle, String question, IModelElement[] modelElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        boolean hasReadOnlyResources = ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(modelElements, resources);
        if (hasReadOnlyResources) {
            IConfirmQuery query = queries.createYesNoQuery(queryTitle, false, 5);
            return query.confirm(question);
        }
        return true;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IModelElement[] modelElements, IResource[] resources) throws CoreException {
        return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(resources) || ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(modelElements);
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IModelElement[] modelElements) throws CoreException {
        int i = 0;
        while (i < modelElements.length) {
            if (ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(modelElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IModelElement modelElement) throws CoreException {
        switch (modelElement.getElementType()) {
            case 5: {
                IResource resource = ReorgUtils.getResource((IModelElement)modelElement);
                return resource != null && Resources.isReadOnly((IResource)resource);
            }
            case 4: {
                IResource packResource = ReorgUtils.getResource((IModelElement)modelElement);
                if (packResource == null) {
                    return false;
                }
                IScriptFolder pack = (IScriptFolder)modelElement;
                if (Resources.isReadOnly((IResource)packResource)) {
                    return true;
                }
                Object[] nonScript = pack.getForeignResources();
                int i = 0;
                while (i < nonScript.length) {
                    Object object = nonScript[i];
                    if (object instanceof IResource && ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources((IResource)object)) {
                        return true;
                    }
                    ++i;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(pack.getChildren());
            }
            case 3: {
                IProjectFragment root = (IProjectFragment)modelElement;
                if (root.isArchive()) {
                    return false;
                }
                IResource pfrResource = ReorgUtils.getResource((IModelElement)modelElement);
                if (pfrResource == null) {
                    return false;
                }
                if (Resources.isReadOnly((IResource)pfrResource)) {
                    return true;
                }
                Object[] nonScript1 = root.getForeignResources();
                int i = 0;
                while (i < nonScript1.length) {
                    Object object = nonScript1[i];
                    if (object instanceof IResource && ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources((IResource)object)) {
                        return true;
                    }
                    ++i;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(root.getChildren());
            }
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource[] resources) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            if (ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(resources[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource resource) throws CoreException {
        if (resource.isLinked()) {
            return false;
        }
        if (Resources.isReadOnly((IResource)resource)) {
            return true;
        }
        if (resource instanceof IContainer) {
            return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(((IContainer)resource).members());
        }
        return false;
    }
}

