/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.profile.ui.ProfilerUIConstants;
import org.eclipse.php.profile.ui.views.ExecutionStatisticsSorter;

public class ExecutionStatisticsFieldFilter
extends ViewerFilter
implements IXMLPreferencesStorable {
    public static final String DESC_HIGHEST = "Highest";
    public static final String DESC_LOWEST = "Lowest";
    public static final String FIELD_CALLS_COUNT = "Calls Count";
    public static final String FIELD_AVERAGE_OWN_TIME = "Average Own Time";
    public static final String FIELD_OWN_TIME = "Own Time";
    public static final String FIELD_OTHERS_TIME = "Others Time";
    public static final String FIELD_TOTAL_TIME = "Total Time";
    private String fDescriptor;
    private int fNumber;
    private String fField;
    private ExecutionStatisticsSorter fSorter;

    public ExecutionStatisticsFieldFilter() {
        this.fSorter = new ExecutionStatisticsSorter();
    }

    public ExecutionStatisticsFieldFilter(String descriptor, int number, String field) {
        this.fDescriptor = descriptor;
        this.fNumber = number;
        this.fField = field;
        this.fSorter = new ExecutionStatisticsSorter();
    }

    public String getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(String descriptor) {
        this.fDescriptor = descriptor;
    }

    public int getNumber() {
        return this.fNumber;
    }

    public void setNumber(int number) {
        this.fNumber = number;
    }

    public String getField() {
        return this.fField;
    }

    public void setField(String field) {
        this.fField = field;
    }

    public Map<String, Object> storeToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("descriptor", this.fDescriptor);
        map.put("number", this.fNumber);
        map.put("field", this.fField);
        return map;
    }

    public void restoreFromMap(Map<String, Object> map) {
        this.fDescriptor = (String)map.get("descriptor");
        this.fNumber = Integer.parseInt((String)map.get("number"));
        this.fField = (String)map.get("field");
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return true;
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (FIELD_AVERAGE_OWN_TIME.equals(this.fField)) {
            this.fSorter.setColumn(0);
        } else if (FIELD_CALLS_COUNT.equals(this.fField)) {
            this.fSorter.setColumn(1);
        } else if (FIELD_OTHERS_TIME.equals(this.fField)) {
            this.fSorter.setColumn(2);
        } else if (FIELD_OWN_TIME.equals(this.fField)) {
            this.fSorter.setColumn(3);
        } else if (FIELD_TOTAL_TIME.equals(this.fField)) {
            this.fSorter.setColumn(4);
        }
        if (DESC_HIGHEST.equals(this.fDescriptor)) {
            this.fSorter.setOrder(ProfilerUIConstants.SORT_DESCENDING);
        } else if (DESC_LOWEST.equals(this.fDescriptor)) {
            this.fSorter.setOrder(ProfilerUIConstants.SORT_ASCENDING);
        }
        elements = (Object[])elements.clone();
        this.fSorter.sort(viewer, elements);
        ArrayList<Object> resultElements = new ArrayList<Object>(elements.length);
        int countElements = 0;
        int i = 0;
        while (i < elements.length && countElements < this.fNumber) {
            resultElements.add(elements[i]);
            if (i <= 0 || this.fSorter.compare(viewer, elements[i - 1], elements[i]) != 0) {
                ++countElements;
            }
            ++i;
        }
        return resultElements.toArray(new Object[resultElements.size()]);
    }
}

