/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class PackageDefinition
extends DatabaseObjectDefinition {
    protected Vector statements = new Vector();
    protected Vector procedures = new Vector();

    public void addProcedures(StoredProcedureDefinition procedure) {
        this.getProcedures().addElement(procedure);
    }

    public void addStatement(String statement) {
        this.getStatements().addElement(statement);
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            DatabasePlatform platform = session.getPlatform();
            writer.write("CREATE PACKAGE " + this.getFullName());
            writer.write(" AS");
            writer.write("\n");
            Enumeration statementsEnum = this.getStatements().elements();
            while (statementsEnum.hasMoreElements()) {
                writer.write((String)statementsEnum.nextElement());
                writer.write(platform.getBatchDelimiterString());
                writer.write("\n");
            }
            Enumeration proceduresEnum = this.getProcedures().elements();
            while (proceduresEnum.hasMoreElements()) {
                writer.write("\n");
                String procedureString = ((StoredProcedureDefinition)proceduresEnum.nextElement()).buildCreationWriter(session, writer).toString();
                writer.write(procedureString.substring(7, procedureString.length()));
                writer.write("\n");
            }
            writer.write(platform.getBatchEndString());
            writer.write("\n" + session.getPlatform().getStoredProcedureTerminationToken());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP PACKAGE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Vector getProcedures() {
        return this.procedures;
    }

    public Vector getStatements() {
        return this.statements;
    }

    public void setProcedures(Vector procedures) {
        this.procedures = procedures;
    }

    public void setStatements(Vector statements) {
        this.statements = statements;
    }
}

