/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.util.EventObject;
import java.util.Hashtable;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;

public class SessionEvent
extends EventObject {
    protected DatabaseQuery query;
    protected Object result;
    protected Session session;
    protected int eventCode;
    protected Hashtable properties;
    public static final int PreExecuteQuery = 1;
    public static final int PostExecuteQuery = 2;
    public static final int PreBeginTransaction = 3;
    public static final int PostBeginTransaction = 4;
    public static final int PreCommitTransaction = 5;
    public static final int PostCommitTransaction = 6;
    public static final int PreRollbackTransaction = 7;
    public static final int PostRollbackTransaction = 8;
    public static final int PostAcquireUnitOfWork = 9;
    public static final int PreCommitUnitOfWork = 10;
    public static final int PostCommitUnitOfWork = 11;
    public static final int PreReleaseUnitOfWork = 12;
    public static final int PostReleaseUnitOfWork = 13;
    public static final int PrepareUnitOfWork = 14;
    public static final int PostResumeUnitOfWork = 15;
    public static final int PostAcquireClientSession = 16;
    public static final int PreReleaseClientSession = 17;
    public static final int PostReleaseClientSession = 18;
    public static final int PostAcquireConnection = 22;
    public static final int PostAcquireExclusiveConnection = 33;
    public static final int PreReleaseConnection = 23;
    public static final int PreReleaseExclusiveConnection = 34;
    public static final int OutputParametersDetected = 19;
    public static final int MoreRowsDetected = 20;
    public static final int PostConnect = 21;
    public static final int PreLogin = 24;
    public static final int PostLogin = 25;
    public static final int PreLogout = 40;
    public static final int PostLogout = 41;
    public static final int PreMergeUnitOfWorkChangeSet = 26;
    public static final int PreDistributedMergeUnitOfWorkChangeSet = 27;
    public static final int PostMergeUnitOfWorkChangeSet = 28;
    public static final int PostDistributedMergeUnitOfWorkChangeSet = 29;
    public static final int PreCalculateUnitOfWorkChangeSet = 30;
    public static final int PostCalculateUnitOfWorkChangeSet = 31;
    public static final int MissingDescriptor = 32;
    public static final int NoRowsModified = 35;

    public SessionEvent(int eventCode, Session session) {
        super(session);
        this.session = session;
        this.eventCode = eventCode;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable(2);
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public Object getResult() {
        return this.result;
    }

    public Session getSession() {
        return this.session;
    }

    public void setEventCode(int eventCode) {
        this.eventCode = eventCode;
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

