/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.IOException;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.ConnectionCustomizer;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.QuerySequence;
import org.eclipse.persistence.sequencing.Sequence;

public class DatasourcePlatform
implements Platform {
    protected String tableQualifier = "";
    protected transient ConversionManager conversionManager;
    protected ValueReadQuery timestampQuery;
    protected transient Map platformOperators;
    protected Hashtable dataTypesConvertedFromAClass;
    protected Hashtable dataTypesConvertedToAClass;
    protected Sequence defaultSequence;
    protected Map sequences;
    protected String startDelimiter = "";
    protected String endDelimiter = "";
    protected Object sequencesLock = new Boolean(true);
    protected boolean defaultNativeSequenceToTable;
    protected boolean defaultSeqenceAtNextValue;

    public boolean getDefaultNativeSequenceToTable() {
        return this.defaultNativeSequenceToTable;
    }

    public void setDefaultNativeSequenceToTable(boolean defaultNativeSequenceToTable) {
        this.defaultNativeSequenceToTable = defaultNativeSequenceToTable;
    }

    public boolean getDefaultSeqenceAtNextValue() {
        return this.defaultSeqenceAtNextValue;
    }

    public void setDefaultSeqenceAtNextValue(boolean defaultSeqenceAtNextValue) {
        this.defaultSeqenceAtNextValue = defaultSeqenceAtNextValue;
    }

    protected void addOperator(ExpressionOperator operator) {
        this.platformOperators.put(operator.getSelector(), operator);
    }

    @Override
    public void appendParameter(Call call, Writer writer, Object parameter) {
        String parameterValue = (String)this.getConversionManager().convertObject(parameter, ClassConstants.STRING);
        if (parameterValue == null) {
            parameterValue = "";
        }
        try {
            writer.write(parameterValue);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    @Override
    public Object getCustomModifyValueForCall(Call call, Object value, DatabaseField field, boolean shouldBind) {
        return value;
    }

    @Override
    public boolean shouldUseCustomModifyForCall(DatabaseField field) {
        return false;
    }

    @Override
    public Object clone() {
        try {
            DatasourcePlatform clone = (DatasourcePlatform)super.clone();
            clone.sequencesAfterCloneCleanup();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void sequencesAfterCloneCleanup() {
        Sequence defaultSequenceClone = null;
        if (this.hasDefaultSequence()) {
            defaultSequenceClone = (Sequence)this.getDefaultSequence().clone();
            this.setDefaultSequence(defaultSequenceClone);
        }
        if (this.getSequences() != null) {
            HashMap sequencesCopy = new HashMap(this.getSequences());
            HashMap<String, Sequence> sequencesDeepClone = new HashMap<String, Sequence>(this.getSequences().size());
            for (Sequence sequence : sequencesCopy.values()) {
                if (defaultSequenceClone != null && sequence == this.getDefaultSequence()) {
                    sequencesDeepClone.put(defaultSequenceClone.getName(), defaultSequenceClone);
                    continue;
                }
                Sequence sequenceClone = (Sequence)sequence.clone();
                if (sequenceClone instanceof DefaultSequence && !((DefaultSequence)sequenceClone).hasPreallocationSize()) continue;
                sequencesDeepClone.put(sequenceClone.getName(), sequenceClone);
            }
            this.setSequences(sequencesDeepClone);
        }
    }

    @Override
    public Object convertObject(Object sourceObject, Class javaClass) throws ConversionException {
        return this.getConversionManager().convertObject(sourceObject, javaClass);
    }

    @Override
    public void copyInto(Platform platform) {
        if (!(platform instanceof DatasourcePlatform)) {
            return;
        }
        DatasourcePlatform datasourcePlatform = (DatasourcePlatform)platform;
        datasourcePlatform.setTableQualifier(this.getTableQualifier());
        datasourcePlatform.setTimestampQuery(this.timestampQuery);
        datasourcePlatform.setConversionManager(this.getConversionManager());
        if (this.hasDefaultSequence()) {
            datasourcePlatform.setDefaultSequence(this.getDefaultSequence());
        }
        datasourcePlatform.setSequences(this.getSequences());
        datasourcePlatform.sequencesAfterCloneCleanup();
        datasourcePlatform.setDefaultNativeSequenceToTable(this.getDefaultNativeSequenceToTable());
        datasourcePlatform.setDefaultSeqenceAtNextValue(this.getDefaultSeqenceAtNextValue());
    }

    @Override
    public ConversionManager getConversionManager() {
        if (this.conversionManager == null) {
            this.conversionManager = (ConversionManager)ConversionManager.getDefaultManager().clone();
        }
        return this.conversionManager;
    }

    @Override
    public void setConversionManager(ConversionManager conversionManager) {
        this.conversionManager = conversionManager;
    }

    @Override
    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
    }

    public ExpressionOperator getOperator(int selector) {
        return (ExpressionOperator)this.getPlatformOperators().get(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPlatformOperators() {
        if (this.platformOperators == null) {
            DatasourcePlatform datasourcePlatform = this;
            synchronized (datasourcePlatform) {
                if (this.platformOperators == null) {
                    this.initializePlatformOperators();
                }
            }
        }
        return this.platformOperators;
    }

    public ValueReadQuery getSelectSequenceQuery() {
        if (this.getDefaultSequence() instanceof QuerySequence) {
            return ((QuerySequence)this.getDefaultSequence()).getSelectQuery();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getSelectQuery");
    }

    public int getSequencePreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    @Override
    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public void setStartDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
    }

    @Override
    public String getTableQualifier() {
        return this.tableQualifier;
    }

    @Override
    public Timestamp getTimestampFromServer(AbstractSession session, String sessionName) {
        if (this.getTimestampQuery() == null) {
            return new Timestamp(System.currentTimeMillis());
        }
        this.getTimestampQuery().setSessionName(sessionName);
        return (Timestamp)session.executeQuery(this.getTimestampQuery());
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        return this.timestampQuery;
    }

    public DataModifyQuery getUpdateSequenceQuery() {
        if (this.getDefaultSequence() instanceof QuerySequence) {
            return ((QuerySequence)this.getDefaultSequence()).getUpdateQuery();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getUpdateQuery");
    }

    protected void initializePlatformOperators() {
        this.platformOperators = new HashMap();
        this.addOperator(ExpressionOperator.equalOuterJoin());
        this.addOperator(ExpressionOperator.toUpperCase());
        this.addOperator(ExpressionOperator.toLowerCase());
        this.addOperator(ExpressionOperator.chr());
        this.addOperator(ExpressionOperator.concat());
        this.addOperator(ExpressionOperator.hexToRaw());
        this.addOperator(ExpressionOperator.initcap());
        this.addOperator(ExpressionOperator.instring());
        this.addOperator(ExpressionOperator.soundex());
        this.addOperator(ExpressionOperator.leftPad());
        this.addOperator(ExpressionOperator.leftTrim());
        this.addOperator(ExpressionOperator.leftTrim2());
        this.addOperator(ExpressionOperator.replace());
        this.addOperator(ExpressionOperator.rightPad());
        this.addOperator(ExpressionOperator.rightTrim());
        this.addOperator(ExpressionOperator.rightTrim2());
        this.addOperator(ExpressionOperator.substring());
        this.addOperator(ExpressionOperator.substringSingleArg());
        this.addOperator(ExpressionOperator.toNumber());
        this.addOperator(ExpressionOperator.toChar());
        this.addOperator(ExpressionOperator.toCharWithFormat());
        this.addOperator(ExpressionOperator.translate());
        this.addOperator(ExpressionOperator.trim());
        this.addOperator(ExpressionOperator.trim2());
        this.addOperator(ExpressionOperator.ascii());
        this.addOperator(ExpressionOperator.length());
        this.addOperator(ExpressionOperator.locate());
        this.addOperator(ExpressionOperator.locate2());
        this.addOperator(ExpressionOperator.nullIf());
        this.addOperator(ExpressionOperator.ifNull());
        this.addOperator(ExpressionOperator.cast());
        this.addOperator(ExpressionOperator.regexp());
        this.addOperator(ExpressionOperator.union());
        this.addOperator(ExpressionOperator.unionAll());
        this.addOperator(ExpressionOperator.intersect());
        this.addOperator(ExpressionOperator.intersectAll());
        this.addOperator(ExpressionOperator.except());
        this.addOperator(ExpressionOperator.exceptAll());
        this.addOperator(ExpressionOperator.addMonths());
        this.addOperator(ExpressionOperator.dateToString());
        this.addOperator(ExpressionOperator.lastDay());
        this.addOperator(ExpressionOperator.monthsBetween());
        this.addOperator(ExpressionOperator.nextDay());
        this.addOperator(ExpressionOperator.roundDate());
        this.addOperator(ExpressionOperator.toDate());
        this.addOperator(ExpressionOperator.today());
        this.addOperator(ExpressionOperator.currentDate());
        this.addOperator(ExpressionOperator.currentTime());
        this.addOperator(ExpressionOperator.extract());
        this.addOperator(ExpressionOperator.simpleMath(78, "+"));
        this.addOperator(ExpressionOperator.simpleMath(79, "-"));
        this.addOperator(ExpressionOperator.simpleMath(81, "*"));
        this.addOperator(ExpressionOperator.simpleMath(80, "/"));
        this.addOperator(ExpressionOperator.negate());
        this.addOperator(ExpressionOperator.ceil());
        this.addOperator(ExpressionOperator.cos());
        this.addOperator(ExpressionOperator.cosh());
        this.addOperator(ExpressionOperator.abs());
        this.addOperator(ExpressionOperator.acos());
        this.addOperator(ExpressionOperator.asin());
        this.addOperator(ExpressionOperator.atan());
        this.addOperator(ExpressionOperator.exp());
        this.addOperator(ExpressionOperator.sqrt());
        this.addOperator(ExpressionOperator.floor());
        this.addOperator(ExpressionOperator.ln());
        this.addOperator(ExpressionOperator.log());
        this.addOperator(ExpressionOperator.mod());
        this.addOperator(ExpressionOperator.power());
        this.addOperator(ExpressionOperator.round());
        this.addOperator(ExpressionOperator.sign());
        this.addOperator(ExpressionOperator.sin());
        this.addOperator(ExpressionOperator.sinh());
        this.addOperator(ExpressionOperator.tan());
        this.addOperator(ExpressionOperator.tanh());
        this.addOperator(ExpressionOperator.trunc());
        this.addOperator(ExpressionOperator.greatest());
        this.addOperator(ExpressionOperator.least());
        this.addOperator(ExpressionOperator.standardDeviation());
        this.addOperator(ExpressionOperator.variance());
        this.addOperator(ExpressionOperator.deref());
        this.addOperator(ExpressionOperator.ref());
        this.addOperator(ExpressionOperator.refToHex());
        this.addOperator(ExpressionOperator.value());
        this.addOperator(ExpressionOperator.coalesce());
        this.addOperator(ExpressionOperator.caseStatement());
        this.addOperator(ExpressionOperator.caseConditionStatement());
    }

    public void initializeDefaultQueries(DescriptorQueryManager queryManager, AbstractSession session) {
    }

    @Override
    public boolean isAccess() {
        return false;
    }

    @Override
    public boolean isAttunity() {
        return false;
    }

    @Override
    public boolean isCloudscape() {
        return false;
    }

    @Override
    public boolean isDerby() {
        return false;
    }

    @Override
    public boolean isDB2() {
        return false;
    }

    @Override
    public boolean isHANA() {
        return false;
    }

    @Override
    public boolean isH2() {
        return false;
    }

    @Override
    public boolean isDBase() {
        return false;
    }

    @Override
    public boolean isHSQL() {
        return false;
    }

    @Override
    public boolean isInformix() {
        return false;
    }

    @Override
    public boolean isMySQL() {
        return false;
    }

    @Override
    public boolean isODBC() {
        return false;
    }

    @Override
    public boolean isOracle() {
        return false;
    }

    @Override
    public boolean isOracle9() {
        return false;
    }

    public boolean isPervasive() {
        return false;
    }

    @Override
    public boolean isPostgreSQL() {
        return false;
    }

    @Override
    public boolean isPointBase() {
        return false;
    }

    @Override
    public boolean isSQLAnywhere() {
        return false;
    }

    public boolean isFirebird() {
        return false;
    }

    @Override
    public boolean isSQLServer() {
        return false;
    }

    @Override
    public boolean isSybase() {
        return false;
    }

    @Override
    public boolean isSymfoware() {
        return false;
    }

    @Override
    public boolean isTimesTen() {
        return false;
    }

    @Override
    public boolean isTimesTen7() {
        return false;
    }

    @Override
    public boolean isMaxDB() {
        return false;
    }

    @Override
    public void initialize() {
    }

    public void setSelectSequenceNumberQuery(ValueReadQuery seqQuery) {
        if (!(this.getDefaultSequence() instanceof QuerySequence)) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setSelectQuery");
        }
        ((QuerySequence)this.getDefaultSequence()).setSelectQuery(seqQuery);
    }

    public void setSequencePreallocationSize(int size) {
        this.getDefaultSequence().setPreallocationSize(size);
    }

    @Override
    public void setTableQualifier(String qualifier) {
        this.tableQualifier = qualifier;
    }

    @Override
    public void setTimestampQuery(ValueReadQuery tsQuery) {
        this.timestampQuery = tsQuery;
    }

    public void setUpdateSequenceQuery(DataModifyQuery updateSequenceNumberQuery) {
        if (!(this.getDefaultSequence() instanceof QuerySequence)) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setUpdateQuery");
        }
        ((QuerySequence)this.getDefaultSequence()).setUpdateQuery(updateSequenceNumberQuery);
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass());
    }

    public Vector getDataTypesConvertedFrom(Class javaClass) {
        return this.getConversionManager().getDataTypesConvertedFrom(javaClass);
    }

    public Vector getDataTypesConvertedTo(Class javaClass) {
        return this.getConversionManager().getDataTypesConvertedTo(javaClass);
    }

    @Override
    public Sequence getDefaultSequence() {
        if (!this.hasDefaultSequence()) {
            this.setDefaultSequence(this.createPlatformDefaultSequence());
        }
        return this.defaultSequence;
    }

    public boolean hasDefaultSequence() {
        return this.defaultSequence != null;
    }

    @Override
    public void setDefaultSequence(Sequence sequence) {
        if (sequence instanceof DefaultSequence) {
            Sequence platformDefaultSequence = this.createPlatformDefaultSequence();
            if (platformDefaultSequence != null) {
                platformDefaultSequence.setName(sequence.getName());
                if (((DefaultSequence)sequence).hasPreallocationSize()) {
                    platformDefaultSequence.setPreallocationSize(sequence.getPreallocationSize());
                }
            }
            this.defaultSequence = platformDefaultSequence;
        } else {
            this.defaultSequence = sequence;
        }
    }

    @Override
    public void addSequence(Sequence sequence) {
        this.addSequence(sequence, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSequence(Sequence sequence, boolean isSessionConnected) {
        Object object = this.sequencesLock;
        synchronized (object) {
            if (isSessionConnected) {
                if (this.sequences == null) {
                    this.sequences = new HashMap();
                    this.sequences.put(sequence.getName(), sequence);
                } else if (!this.sequences.containsKey(sequence.getName())) {
                    Map newSequences = (Map)((HashMap)this.sequences).clone();
                    newSequences.put(sequence.getName(), sequence);
                    this.sequences = newSequences;
                }
            } else {
                if (this.sequences == null) {
                    this.sequences = new HashMap();
                }
                this.sequences.put(sequence.getName(), sequence);
            }
        }
    }

    @Override
    public Sequence getSequence(String seqName) {
        if (seqName == null) {
            return this.getDefaultSequence();
        }
        if (this.sequences != null) {
            return (Sequence)this.sequences.get(seqName);
        }
        return null;
    }

    protected Sequence createPlatformDefaultSequence() {
        throw ValidationException.createPlatformDefaultSequenceUndefined(Helper.getShortClassName(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence removeSequence(String seqName) {
        if (this.sequences != null) {
            Object object = this.sequencesLock;
            synchronized (object) {
                return (Sequence)this.sequences.remove(seqName);
            }
        }
        return null;
    }

    @Override
    public void removeAllSequences() {
        this.sequences = null;
    }

    @Override
    public Map getSequences() {
        return this.sequences;
    }

    @Override
    public Map getSequencesToWrite() {
        if (this.getSequences() == null || this.getSequences().isEmpty()) {
            return null;
        }
        HashMap sequencesCopy = new HashMap(this.getSequences());
        HashMap<String, Sequence> sequencesToWrite = new HashMap<String, Sequence>();
        for (Sequence sequence : sequencesCopy.values()) {
            if (sequence instanceof DefaultSequence && !((DefaultSequence)sequence).hasPreallocationSize()) continue;
            sequencesToWrite.put(sequence.getName(), sequence);
        }
        return sequencesToWrite;
    }

    @Override
    public Sequence getDefaultSequenceToWrite() {
        if (this.usesPlatformDefaultSequence()) {
            return null;
        }
        return this.getDefaultSequence();
    }

    @Override
    public void setSequences(Map sequences) {
        this.sequences = sequences;
    }

    @Override
    public boolean usesPlatformDefaultSequence() {
        if (!this.hasDefaultSequence()) {
            return true;
        }
        return this.getDefaultSequence().equals(this.createPlatformDefaultSequence());
    }

    @Deprecated
    public String getIdentifierQuoteCharacter() {
        return "";
    }

    public ConnectionCustomizer createConnectionCustomizer(Accessor accessor, AbstractSession session) {
        return null;
    }

    public boolean shouldPrepare(DatabaseQuery query) {
        return true;
    }

    public boolean shouldSelectIncludeOrderBy() {
        return false;
    }

    public boolean shouldSelectDistinctIncludeOrderBy() {
        return true;
    }

    public boolean shouldNativeSequenceUseTransaction() {
        return false;
    }

    public boolean supportsIdentity() {
        return false;
    }

    public boolean supportsNativeSequenceNumbers() {
        return this.supportsSequenceObjects() || this.supportsIdentity();
    }

    public boolean supportsSequenceObjects() {
        return false;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject() {
        return null;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject(String qualifiedSeqName, Integer size) {
        return null;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        return null;
    }

    public ValueReadQuery buildSelectQueryForIdentity(String seqName, Integer size) {
        return null;
    }

    public DatasourceCall buildNativeCall(String queryString) {
        return new SQLCall(queryString);
    }

    public Expression createExpressionFor(DatabaseField field, Expression builder) {
        Expression subExp1 = builder.getField(field);
        Expression subExp2 = builder.getParameter(field);
        return subExp1.equal(subExp2);
    }
}

